/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import in.serosoft.CriteriaBuilderConfigurer.SavedSearchConfigurationApp;
import in.serosoft.CriteriaBuilderConfigurer.SearchResultViewConfigurationApp;
import in.serosoft.CriteriaBuilderConfigurer.ViewDefinitionConfigurationApp;
import in.serosoft.cb.MetadataFiller.Dao;
import in.serosoft.cb.entity.SearchConfig;
import in.serosoft.cb.entity.SearchTable;
import in.serosoft.cb.entity.SearchTableColumn;
import in.serosoft.cb.entity.SearchTableColumnCustomCategory;
import in.serosoft.cb.entity.SearchTableRelation;
import in.serosoft.cb.helper.ConfigurationHelper;
import in.serosoft.cb.model.CustomField;
import in.serosoft.cb.model.SearchConfigDTO;
import in.serosoft.cb.service.SearchConfiguratonService;
import in.serosoft.cb.service.SearchTableColumnCustomCategoryService;
import in.serosoft.cb.service.SearchTableColumnService;
import in.serosoft.cb.service.SearchTableService;
import in.serosoft.cb.util.threadPool.ThreadJob;
import in.serosoft.cb.util.threadPool.ThreadPool;
import in.serosoft.cb.xmlParser.ConfigurationReader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DataConfigurerApp {
    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext("spring/serosoft-academia-spring-bean.xml");
        final SearchConfiguratonService searchConfiguratonService = (SearchConfiguratonService)appContext.getBean("searchConfiguratonService");
        DataConfigurerApp.preConfigure();
        Dao cbdb = new Dao();
        cbdb.updateTableDetails();
        List<String> nonExecutedViewDefinitionXmls = ViewDefinitionConfigurationApp.inserViewDefinitions(searchConfiguratonService);
        List<File> listofFiles = DataConfigurerApp.readFileNames();
        List<SearchTable> searchTables = searchConfiguratonService.findAllSearchTables();
        final Map<String, SearchTable> searchTablesMap = ConfigurationHelper.getSearchTablesMap(searchTables);
        final List<SearchTableRelation> searchTableRelations = searchConfiguratonService.findAllSearchTableRelations();
        final CopyOnWriteArrayList searchConfigs = new CopyOnWriteArrayList();
        final ArrayList<String> nonExecutedXmls = new ArrayList<String>();
        ExecutorService executor = ThreadPool.getExecutor();
        int counter = listofFiles.size();
        for (final File cbXmlFIle : listofFiles) {
            ThreadJob newJob = new ThreadJob(counter--){

                @Override
                public void run() {
                    try {
                        if (cbXmlFIle.isFile() && cbXmlFIle.getName().endsWith(".xml")) {
                            String fileName = cbXmlFIle.getPath();
                            SearchConfigDTO searchConfigDTO = ConfigurationReader.readXmlFile(fileName);
                            try {
                                searchConfigs.add(searchConfiguratonService.configureAll(searchConfigDTO, searchTablesMap, searchTableRelations));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                nonExecutedXmls.add(fileName);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            executor.execute(newJob);
        }
        try {
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (SearchConfig searchConfig : searchConfigs) {
            try {
                searchConfiguratonService.createSearchConfig(searchConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
                nonExecutedXmls.add("issue on create- " + searchConfig.getConfigCode());
            }
        }
        DataConfigurerApp.updateStandardMasterFields(searchConfiguratonService);
        DataConfigurerApp.postConfigure();
        searchConfiguratonService.disableSortingForAggregateColumns();
        DataConfigurerApp.updateCustomFields(searchConfiguratonService, (ApplicationContext)appContext);
        try {
            DataConfigurerApp.updateSearchTableCustomCategory((ApplicationContext)appContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void updateStandardMasterFields(SearchConfiguratonService searchConfiguratonService) {
        searchConfiguratonService.updateStandardMasterColumns();
    }

    private static void updateCustomFields(SearchConfiguratonService searchConfiguratonService, ApplicationContext appContext) {
        SearchTableColumnService searchTableColumnService = (SearchTableColumnService)appContext.getBean("searchTableColumnService");
        List<CustomField> customFields = searchConfiguratonService.findAllCustomFields();
        for (CustomField customField : customFields) {
            if (customField.getWhetherStandardMaster().booleanValue()) {
                customField.setWhetherSimpleCatagory(false);
            } else if (customField.getWhetherSimpleCatagory().booleanValue()) {
                customField.setTableColumnReff("categories_info#subCategoryName");
            } else {
                customField.setTableColumnReff(null);
                customField.setCustomFieldConfigId(null);
            }
            searchTableColumnService.updateCBCustomField(customField);
        }
    }

    private static List<File> readFileNames() {
        File idGeneratorXMLfolder = new File("src/main/resources/XMLParser/idGeneratorXML/");
        File[] idGeneratorlistofFiles = idGeneratorXMLfolder.listFiles();
        File folder = new File("src/main/resources/XMLParser/cbxml/");
        File reportFolder = new File("src/main/resources/XMLParser/reportXML/");
        File msgxmlFolder = new File("src/main/resources/XMLParser/msgxml/");
        ArrayList<File> listofFiles = new ArrayList<File>();
        File[] cblistofFiles = folder.listFiles();
        File[] reportFileList = reportFolder.listFiles();
        File[] msgxmlFileList = msgxmlFolder.listFiles();
        for (File file : cblistofFiles) {
            listofFiles.add(file);
        }
        for (File file : idGeneratorlistofFiles) {
            listofFiles.add(file);
        }
        for (File file : reportFileList) {
            listofFiles.add(file);
        }
        for (File file : msgxmlFileList) {
            listofFiles.add(file);
        }
        return listofFiles;
    }

    private static void postConfigure() {
        SavedSearchConfigurationApp.restore("src/main/resources/XMLParser/savedSearches/");
    }

    private static void preConfigure() {
        SearchResultViewConfigurationApp.backup("src/main/resources/XMLParser/searchResultViews/");
        SavedSearchConfigurationApp.backup("src/main/resources/XMLParser/savedSearches/");
    }

    private static void updateSearchTableCustomCategory(ApplicationContext appContext) {
        SearchTableColumnCustomCategoryService categoryService = (SearchTableColumnCustomCategoryService)appContext.getBean("searchTableColumnCustomCategoryService");
        SearchTableService searchTableService = (SearchTableService)appContext.getBean("searchTableService");
        SearchTableColumnService searchTableColumnService = (SearchTableColumnService)appContext.getBean("searchTableColumnService");
        Long searchTableId = searchTableService.findSearchTableIdByTableName("person_cd");
        List<SearchTableColumnCustomCategory> searchTableColumnCustomCategories = categoryService.findAllUserTypeCategory();
        if (searchTableId != null) {
            List<SearchTableColumn> searchTableColumns = searchTableColumnService.findColumnBySearchTableId(searchTableId);
            HashMap<String, SearchTableColumn> ColNameAndSearchTableColumn = new HashMap<String, SearchTableColumn>();
            for (SearchTableColumn searchTableColumn : searchTableColumns) {
                ColNameAndSearchTableColumn.put(searchTableColumn.getColumnName(), searchTableColumn);
            }
            for (SearchTableColumnCustomCategory sCustomCategory : searchTableColumnCustomCategories) {
                if (!ColNameAndSearchTableColumn.containsKey(sCustomCategory.getColumnName())) continue;
                sCustomCategory.setSearchTableColumnId(((SearchTableColumn)ColNameAndSearchTableColumn.get(sCustomCategory.getColumnName())).getId());
                sCustomCategory.setSearchTable(((SearchTableColumn)ColNameAndSearchTableColumn.get(sCustomCategory.getColumnName())).getSearchTable());
                categoryService.updateCustomCategory(sCustomCategory);
            }
        }
    }
}

