/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import in.serosoft.cb.model.SavedSearchDTO;
import in.serosoft.cb.model.SavedSearchesDTO;
import in.serosoft.cb.service.SearchConfiguratonService;
import in.serosoft.cb.xmlParser.ConfigurationReader;
import in.serosoft.cb.xmlParser.DBSchemaReader;
import java.io.File;
import java.util.ArrayList;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SavedSearchConfigurationApp {
    public static void main(String[] args) {
        String fileName = "src/main/resources/XMLParser/savedSearches/";
        SavedSearchConfigurationApp.backup(fileName);
    }

    public static void backup(String fileName) {
        ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext("spring/serosoft-academia-spring-bean.xml");
        SearchConfiguratonService searchConfiguratonService = (SearchConfiguratonService)appContext.getBean("searchConfiguratonService");
        SavedSearchesDTO savedSearchDTOs = searchConfiguratonService.readSavedSearches();
        for (SavedSearchDTO searchDTO : savedSearchDTOs.getSavedSearchDTOs()) {
            try {
                SavedSearchesDTO searchesDTO = new SavedSearchesDTO();
                ArrayList<SavedSearchDTO> dtos = new ArrayList<SavedSearchDTO>();
                dtos.add(searchDTO);
                searchesDTO.setSavedSearchDTOs(dtos);
                String searchFileName = searchDTO.getSearchName().replace(" ", "_").replace("/", "_").replaceAll("[-+.^:,]", "_");
                DBSchemaReader.readSchemaToWriteXmlFile(searchesDTO, fileName + searchFileName + ".xml");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void restore(String fileName) {
        ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext("spring/serosoft-academia-spring-bean.xml");
        SearchConfiguratonService searchConfiguratonService = (SearchConfiguratonService)appContext.getBean("searchConfiguratonService");
        File folder = new File(fileName);
        File[] listofFiles = folder.listFiles();
        SavedSearchesDTO mainSavedSearcheDTO = new SavedSearchesDTO();
        ArrayList<SavedSearchDTO> dtos = new ArrayList<SavedSearchDTO>();
        for (File file : listofFiles) {
            SavedSearchesDTO savedSearcheDTO = ConfigurationReader.readSavedSearchXmlFile(fileName + file.getName());
            dtos.addAll(savedSearcheDTO.getSavedSearchDTOs());
        }
        mainSavedSearcheDTO.setSavedSearchDTOs(dtos);
        searchConfiguratonService.configureSavedSearch(mainSavedSearcheDTO);
    }
}

