/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import in.serosoft.cb.model.SearchResultViewDTO;
import in.serosoft.cb.service.SearchConfiguratonService;
import in.serosoft.cb.xmlParser.ConfigurationReader;
import in.serosoft.cb.xmlParser.DBSchemaReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SearchResultViewConfigurationApp {
    public static void main(String[] args) {
        String filepath = "src/main/resources/XMLParser/searchResultViews/";
        SearchResultViewConfigurationApp.restore(filepath);
    }

    public static void backup(String filepath) {
        ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext("spring/serosoft-academia-spring-bean.xml");
        SearchConfiguratonService searchConfiguratonService = (SearchConfiguratonService)appContext.getBean("searchConfiguratonService");
        List<SearchResultViewDTO> searchResultViewDTOs = searchConfiguratonService.readSearchResultViews();
        for (SearchResultViewDTO searchResultViewDTO : searchResultViewDTOs) {
            DBSchemaReader.readSchemaToWriteXmlFile(searchResultViewDTO, filepath + searchResultViewDTO.getViewCode() + ".xml");
        }
    }

    public static void restore(String filepath) {
        ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext("spring/serosoft-academia-spring-bean.xml");
        SearchConfiguratonService searchConfiguratonService = (SearchConfiguratonService)appContext.getBean("searchConfiguratonService");
        ArrayList<SearchResultViewDTO> searchResultViewDTOs = new ArrayList<SearchResultViewDTO>();
        File folder = new File(filepath);
        File[] listofFiles = folder.listFiles();
        for (int j = 0; j < listofFiles.length; ++j) {
            File file = listofFiles[j];
            if (!file.isFile() || !file.getName().endsWith(".xml")) continue;
            String fileName = file.getPath();
            SearchResultViewDTO searchResultViewDTO = ConfigurationReader.readSearchResultViewsXmlFile(fileName);
            searchResultViewDTOs.add(searchResultViewDTO);
        }
        searchConfiguratonService.updateSearchResultViews(searchResultViewDTOs);
    }
}

