/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.dao.impl;

import in.serosoft.cb.dao.SearchConfigDAO;
import in.serosoft.cb.dao.impl.CBGenericDAOImpl;
import in.serosoft.cb.entity.SearchConfig;
import in.serosoft.cb.exception.CriteriaBuilderException;
import in.serosoft.cb.model.CustomField;
import in.serosoft.cb.model.SearchConfigIdModel;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BooleanType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.stereotype.Repository;

@Repository(value="searchConfigDAO")
public class SearchConfigDAOImpl
extends CBGenericDAOImpl<SearchConfig, Long>
implements SearchConfigDAO {
    public SearchConfigDAOImpl() {
        super(SearchConfig.class);
    }

    @Override
    public List<SearchConfig> findAll() throws CriteriaBuilderException {
        Criteria criteria = this.getCriteria();
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    @Override
    public void disableSortingForAggregateColumns() {
        String sql = "UPDATE `search_result_view_column` SET `sortable`=FALSE WHERE `searchSQLGroupId`IS NOT NULL";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.executeUpdate();
    }

    @Override
    public void disableSortingForAggregateColumns(String viewCode) {
        String sql = "UPDATE search_result_view_column T1 INNER JOIN `search_result_view`  T2 ON T2.id=T1.`searchResultViewId` SET T1.`sortable`=FALSE WHERE T1.`searchSQLGroupId` IS NOT NULL AND T2.`viewCode` = '" + viewCode + "'";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.executeUpdate();
    }

    @Override
    public List<CustomField> findAllCustomFields() {
        String sql = "SELECT T1.displayName, T2.customTableName AS tableName, T3.columnName ,case when T1.whetherCustomField = 0 and T3.customType = 'CUSTOM_CATEGORY' then 1 else 0 end AS whetherSimpleCatagory,T1.`whetherStandardMaster`,CONCAT(T4.tableName,'#',T4.displayColumnName) AS tableColumnReff,T1.id AS customFieldConfigId FROM custom_field_config T1 LEFT JOIN custom_table_configs T2 ON T1.customTableConfigId = T2.id INNER JOIN column_mappings T3 ON T3.id = T1.columnMappingId LEFT JOIN standard_master_category T4 ON T4.id=T1.`standardMasterCategoryId`";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(CustomField.class));
        query.addScalar("customFieldConfigId", (Type)LongType.INSTANCE);
        query.addScalar("displayName", (Type)StringType.INSTANCE);
        query.addScalar("tableName", (Type)StringType.INSTANCE);
        query.addScalar("columnName", (Type)StringType.INSTANCE);
        query.addScalar("whetherSimpleCatagory", (Type)BooleanType.INSTANCE);
        query.addScalar("whetherStandardMaster", (Type)BooleanType.INSTANCE);
        query.addScalar("tableColumnReff", (Type)StringType.INSTANCE);
        List customFields = query.list();
        return customFields;
    }

    @Override
    public void updateStandardMasterColumns() {
        String sql = "UPDATE search_table_column SET whetherStandardMaster = FALSE,  tableColumnReff = ( SELECT dColumnName FROM (SELECT T1.id  AS dId , CONCAT (T2.dbTableName , '#',T1.columnName )AS dColumnName FROM `search_table_column` T1 INNER JOIN  `search_table` T2 ON T1.`searchTableId`=T2.id INNER JOIN  `standard_master` T3 ON T3.`tableName`=T2.`dbTableName`  AND  T1.dataType='STRING') AS d WHERE dId = id )";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.executeUpdate();
        String flagsql = "UPDATE search_table_column SET whetherStandardMaster = TRUE WHERE id IN ( SELECT id FROM (SELECT T1.id AS id FROM `search_table_column` T1 INNER JOIN  `search_table` T2 ON T1.`searchTableId`=T2.id INNER JOIN  `standard_master` T3 ON T3.`tableName`=T2.`dbTableName`  AND  T1.dataType='STRING' ) AS d )";
        query = this.getCrntSession().createSQLQuery(flagsql);
        query.executeUpdate();
    }

    @Override
    public Long findIdByConfigCode(String configCode) {
        Criteria criteria = this.getCriteria(SearchConfig.class);
        criteria.add((Criterion)Restrictions.eq((String)"configCode", (Object)configCode));
        criteria.setProjection((Projection)Projections.property((String)"id"));
        return (Long)criteria.uniqueResult();
    }

    @Override
    public void deleteOldSearchConfigData(SearchConfigIdModel searchConfigIdModel) {
        String hql = "CALL `search_config_app_data_update`(:searchConfigId, :newSearchConfigId);";
        try {
            SQLQuery query = this.getCrntSession().createSQLQuery(hql);
            query.setParameter("searchConfigId", (Object)searchConfigIdModel.getSearchConfigId());
            query.setParameter("newSearchConfigId", (Object)searchConfigIdModel.getNewSearchConfigId());
            query.executeUpdate();
            System.out.println("Search config data updated. old search config id- " + searchConfigIdModel.getSearchConfigId() + ", New search config id- " + searchConfigIdModel.getNewSearchConfigId());
        }
        catch (CriteriaBuilderException | HibernateException e) {
            System.out.println("Error on Search config data update. old search config id- " + searchConfigIdModel.getSearchConfigId() + ", New search config id- " + searchConfigIdModel.getNewSearchConfigId());
            e.printStackTrace();
        }
    }
}

