/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.helper;

import in.serosoft.cb.dao.SearchTableColumnDAO;
import in.serosoft.cb.dao.SearchTableRelationDAO;
import in.serosoft.cb.entity.SearchTable;
import in.serosoft.cb.entity.SearchTableColumn;
import in.serosoft.cb.entity.SearchTableRelation;
import in.serosoft.cb.model.SearchConfigTableDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigurationHelper {
    public static Map<String, SearchTable> getSearchTablesMap(List<SearchTable> searchTables) {
        HashMap<String, SearchTable> map = new HashMap<String, SearchTable>();
        for (SearchTable searchTable : searchTables) {
            map.put(searchTable.getDbTableName(), searchTable);
        }
        return map;
    }

    public static SearchTableColumn getSearchTableColumn(SearchTableColumnDAO searchTableColumnDAO, String tableName, String columnName, Map<String, SearchTable> map) {
        SearchTable searchTable = map.get(tableName);
        if (columnName.contains("#")) {
            SearchTableColumn searchTableColumn = new SearchTableColumn();
            searchTableColumn.setColumnName(columnName);
            searchTableColumn.setCriteriaPrivilegeLevel("1");
            searchTableColumn.setDataType("STRING");
            searchTableColumn.setDisplayCode("cb." + searchTable.getDbTableName() + "." + columnName);
            searchTableColumn.setSearchTable(searchTable);
            searchTableColumn.setVirtualField("1");
            searchTableColumn.setWhetherOccupied(true);
            searchTableColumn.setWhetherSimpleCatagory(false);
            searchTableColumn.setWhetherStandardMaster(false);
            searchTableColumnDAO.create(searchTableColumn);
            return searchTableColumn;
        }
        Set<SearchTableColumn> searchTableColumns = searchTable.getSearchTableColumns();
        for (SearchTableColumn searchTableColumn : searchTableColumns) {
            if (!searchTableColumn.getColumnName().equalsIgnoreCase(columnName)) continue;
            return searchTableColumn;
        }
        return null;
    }

    public static SearchTableColumn getSearchTableColumn(String tableName, String columnName, Map<String, SearchTable> map) {
        SearchTable searchTable = map.get(tableName);
        Set<SearchTableColumn> searchTableColumns = searchTable.getSearchTableColumns();
        for (SearchTableColumn searchTableColumn : searchTableColumns) {
            if (!searchTableColumn.getColumnName().equalsIgnoreCase(columnName)) continue;
            return searchTableColumn;
        }
        return null;
    }

    public static SearchTableRelation getSearchTableRelation(SearchConfigTableDTO searchConfigTableDTO, List<SearchTableRelation> searchTableRelations, SearchTableRelationDAO searchTableRelationDAO, Map<String, SearchTable> searchTablesMap) {
        String fromTableName = searchConfigTableDTO.getJoinClause().getFromTableName();
        String toTableName = searchConfigTableDTO.getJoinClause().getToTableName();
        String relationKey = searchConfigTableDTO.getJoinClause().getRelationKey();
        String joinClauseCondition = searchConfigTableDTO.getJoinClause().getJoinClauseCondition();
        String dbFromTable = null;
        String dbToTable = null;
        String dbJoinClause = null;
        if (joinClauseCondition == null) {
            for (SearchTableRelation searchTableRelation : searchTableRelations) {
                dbFromTable = searchTableRelation.getSearchTableByFromTableId().getDbTableName();
                dbToTable = searchTableRelation.getSearchTableByToTableId().getDbTableName();
                dbJoinClause = searchTableRelation.getJoinClause();
                if ((!dbFromTable.equalsIgnoreCase(fromTableName) || !dbToTable.equalsIgnoreCase(toTableName)) && (!dbToTable.equalsIgnoreCase(fromTableName) || !dbFromTable.equalsIgnoreCase(toTableName)) || !dbJoinClause.contains(relationKey)) continue;
                return searchTableRelation;
            }
        } else {
            Boolean flag = false;
            for (SearchTableRelation searchTableRelation : searchTableRelations) {
                dbFromTable = searchTableRelation.getSearchTableByFromTableId().getDbTableName();
                dbToTable = searchTableRelation.getSearchTableByToTableId().getDbTableName();
                dbJoinClause = searchTableRelation.getJoinClause();
                if ((dbFromTable.equalsIgnoreCase(fromTableName) && dbToTable.equalsIgnoreCase(toTableName) || dbToTable.equalsIgnoreCase(fromTableName) && dbFromTable.equalsIgnoreCase(toTableName)) && dbJoinClause.equals(joinClauseCondition)) {
                    flag = false;
                    return searchTableRelation;
                }
                flag = true;
            }
            if (flag.booleanValue()) {
                SearchTableRelation dbSearchTableRelation = new SearchTableRelation();
                SearchTable from = searchTablesMap.get(fromTableName);
                SearchTable to = searchTablesMap.get(toTableName);
                dbSearchTableRelation.setSearchTableByFromTableId(from);
                dbSearchTableRelation.setSearchTableByToTableId(to);
                dbSearchTableRelation.setJoinClause(joinClauseCondition);
                searchTableRelationDAO.create(dbSearchTableRelation);
                return dbSearchTableRelation;
            }
        }
        return null;
    }

    private static String toLowerCase(String tableName) {
        if (tableName != null) {
            return tableName.toLowerCase();
        }
        return tableName;
    }
}

