/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.service.impl;

import in.serosoft.cb.dao.SavedSearchDAO;
import in.serosoft.cb.dao.SearchConfigDAO;
import in.serosoft.cb.dao.SearchResultViewDAO;
import in.serosoft.cb.dao.SearchTableColumnDAO;
import in.serosoft.cb.dao.SearchTableDAO;
import in.serosoft.cb.dao.SearchTableRelationDAO;
import in.serosoft.cb.entity.SavedSearch;
import in.serosoft.cb.entity.SearchConfig;
import in.serosoft.cb.entity.SearchConfigTable;
import in.serosoft.cb.entity.SearchResultView;
import in.serosoft.cb.entity.SearchResultViewColumn;
import in.serosoft.cb.entity.SearchSQLGroup;
import in.serosoft.cb.entity.SearchTable;
import in.serosoft.cb.entity.SearchTableRelation;
import in.serosoft.cb.exception.CriteriaBuilderException;
import in.serosoft.cb.helper.ConfigurationHelper;
import in.serosoft.cb.helper.DTOToEntityConvertor;
import in.serosoft.cb.helper.SavedSearchConfigurationHelper;
import in.serosoft.cb.helper.SavedSearchDTOToEntityConvertor;
import in.serosoft.cb.helper.SavedSearchEntityToDTOConvertor;
import in.serosoft.cb.helper.SearchResultViewDTOToEntityConvertor;
import in.serosoft.cb.helper.SearchResultViewEntityToDTOConvertor;
import in.serosoft.cb.helper.ViewDTOToEntityConvertor;
import in.serosoft.cb.model.CustomField;
import in.serosoft.cb.model.SQLViewDTO;
import in.serosoft.cb.model.SavedSearchDTO;
import in.serosoft.cb.model.SavedSearchesDTO;
import in.serosoft.cb.model.SearchConfigDTO;
import in.serosoft.cb.model.SearchConfigIdModel;
import in.serosoft.cb.model.SearchResultViewDTO;
import in.serosoft.cb.service.SearchConfiguratonService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="searchConfiguratonService")
public class SearchConfigurationServiceImpl
implements SearchConfiguratonService {
    @Autowired
    SearchTableDAO searchTableDAO;
    @Autowired
    SearchTableColumnDAO searchTableColumnDAO;
    @Autowired
    SearchTableRelationDAO searchTableRelationDAO;
    @Autowired
    SearchConfigDAO searchConfigDAO;
    @Autowired
    SavedSearchDAO savedSearchDAO;
    @Autowired
    SearchResultViewDAO searchResultViewDAO;

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public List<SearchTable> findAllSearchTables() {
        return this.searchTableDAO.findAllSearchTables();
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public List<SearchTableRelation> findAllSearchTableRelations() {
        return this.searchTableRelationDAO.findAllSearchTableRelations();
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public Long createSearchConfig(SearchConfig searchConfig) {
        Long id = null;
        try {
            id = (Long)this.searchConfigDAO.create(searchConfig);
        }
        catch (CriteriaBuilderException e) {
            e.printStackTrace();
        }
        return id;
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public SearchConfig configureAll(SearchConfigDTO searchConfigDTO, Map<String, SearchTable> searchTablesMap, List<SearchTableRelation> searchTableRelations) {
        DTOToEntityConvertor dtoToEntityConvertor = new DTOToEntityConvertor(searchTablesMap, searchTableRelations, this.searchTableRelationDAO, this.searchTableColumnDAO);
        SearchConfig searchConfig = dtoToEntityConvertor.convertSearchConfigDTOToSearchConfig(searchConfigDTO);
        return searchConfig;
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void configure(SearchConfigDTO searchConfigDTO, SearchConfigIdModel searchConfigIdModel) {
        List<SearchTable> searchTables = this.searchTableDAO.findAllSearchTables();
        List<SearchTableRelation> searchTableRelations = this.searchTableRelationDAO.findAllSearchTableRelations();
        Map<String, SearchTable> searchTablesMap = ConfigurationHelper.getSearchTablesMap(searchTables);
        DTOToEntityConvertor dtoToEntityConvertor = new DTOToEntityConvertor(searchTablesMap, searchTableRelations, this.searchTableRelationDAO, this.searchTableColumnDAO);
        SearchConfig searchConfig = dtoToEntityConvertor.convertSearchConfigDTOToSearchConfig(searchConfigDTO);
        try {
            searchConfigIdModel.setNewSearchConfigId((Long)this.searchConfigDAO.create(searchConfig));
        }
        catch (CriteriaBuilderException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public SavedSearchesDTO readSavedSearches() {
        SavedSearchesDTO savedSearchesDTO = new SavedSearchesDTO();
        ArrayList<SavedSearchDTO> savedSearchDTOs = new ArrayList<SavedSearchDTO>();
        List savedSearches = this.savedSearchDAO.findAll();
        SavedSearchEntityToDTOConvertor entityToDTOConvertor = new SavedSearchEntityToDTOConvertor();
        for (SavedSearch savedSearch : savedSearches) {
            SavedSearchDTO savedSearchDTO = entityToDTOConvertor.convert(savedSearch);
            savedSearchDTOs.add(savedSearchDTO);
        }
        savedSearchesDTO.setSavedSearchDTOs(savedSearchDTOs);
        return savedSearchesDTO;
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public List<SearchResultViewDTO> readSearchResultViews() {
        ArrayList<SearchResultViewDTO> searchResultViewDTOs = new ArrayList<SearchResultViewDTO>();
        List<SearchResultView> searchResultViews = this.searchResultViewDAO.findIdGeneratorSearchResultView();
        SearchResultViewEntityToDTOConvertor convertor = new SearchResultViewEntityToDTOConvertor();
        for (SearchResultView searchResultView : searchResultViews) {
            SearchResultViewDTO searchResultViewDTO = convertor.convert(searchResultView);
            searchResultViewDTOs.add(searchResultViewDTO);
        }
        return searchResultViewDTOs;
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void insertSearchConfig(SearchConfigDTO searchConfigDTO, List<SearchTable> searchTables, Map<String, SearchTable> searchTablesMap, List<SearchTableRelation> searchTableRelations) {
        DTOToEntityConvertor dtoToEntityConvertor = new DTOToEntityConvertor(searchTablesMap, searchTableRelations, this.searchTableRelationDAO, this.searchTableColumnDAO);
        SearchConfig searchConfig = dtoToEntityConvertor.convertSearchConfigDTOToSearchConfig(searchConfigDTO);
        this.searchConfigDAO.create(searchConfig);
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void configureSQLView(SQLViewDTO sqlViewDTO) {
        ViewDTOToEntityConvertor viewDTOToEntityConvertor = new ViewDTOToEntityConvertor();
        SearchTable searchTable = viewDTOToEntityConvertor.convertSQLViewDTOToSearchTable(sqlViewDTO);
        this.searchTableDAO.create(searchTable);
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void configureSavedSearch(SavedSearchesDTO savedSearchesDTO) {
        List<SearchConfig> searchConfigs = this.searchConfigDAO.findAll();
        Map<String, SearchConfig> searchConfigMap = SavedSearchConfigurationHelper.buildSearchConfigMap(searchConfigs);
        List<SearchResultView> searchResultViews = this.searchResultViewDAO.findAll();
        Map<String, SearchResultView> searchResultViewMap = SavedSearchConfigurationHelper.buildSearchResultViewMap(searchResultViews);
        Map<String, Map<String, SearchConfigTable>> searchConfigTablesMap = SavedSearchConfigurationHelper.buildSearchConfigTablesMap(searchConfigs);
        List<SearchTable> searchTables = this.searchTableDAO.findAllSearchTables();
        Map<String, SearchTable> searchTablesMap = ConfigurationHelper.getSearchTablesMap(searchTables);
        List<SearchTableRelation> searchTableRelations = this.searchTableRelationDAO.findAllSearchTableRelations();
        SavedSearchDTOToEntityConvertor searchDTOToEntityConvertor = new SavedSearchDTOToEntityConvertor(searchConfigMap, searchResultViewMap, searchConfigTablesMap, searchTablesMap, searchTableRelations, this.searchTableRelationDAO, this.searchTableColumnDAO);
        List<SavedSearch> savedSearches = searchDTOToEntityConvertor.covertSavedSearchesDTOToSavedSearch(savedSearchesDTO);
        for (SavedSearch savedSearch : savedSearches) {
            if (savedSearch.getSearchResultView().getViewCode().contains("USER_SAVED_VIEW")) {
                this.searchResultViewDAO.create(savedSearch.getSearchResultView());
            }
            this.savedSearchDAO.create(savedSearch);
        }
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void updateSearchResultViews(List<SearchResultViewDTO> searchResultViewDTOs) {
        List<SearchTable> searchTables = this.searchTableDAO.findAllSearchTables();
        Map<String, SearchTable> searchTablesMap = ConfigurationHelper.getSearchTablesMap(searchTables);
        List<SearchTableRelation> searchTableRelations = this.searchTableRelationDAO.findAllSearchTableRelations();
        ArrayList<String> nonExecutedViews = new ArrayList<String>();
        for (SearchResultViewDTO searchResultViewDTO : searchResultViewDTOs) {
            try {
                SearchResultView savedSearchResultView = this.searchResultViewDAO.findByViewCode(searchResultViewDTO.getViewCode());
                Map<String, SearchConfigTable> searchConfigTablesMap = this.buldSearchConfigTablesMapForView(savedSearchResultView);
                SearchResultViewDTOToEntityConvertor dtoToEntityConvertor = new SearchResultViewDTOToEntityConvertor(searchTablesMap, searchTableRelations, this.searchTableRelationDAO, this.searchTableColumnDAO, searchConfigTablesMap);
                SearchResultView searchResultView = dtoToEntityConvertor.convertSearchResultViewDTOToEntity(searchResultViewDTO);
                Set<SearchResultViewColumn> searchResultViewColumns = this.fillSearchResultViewColumnParents(searchResultView.getSearchResultViewColumns(), savedSearchResultView);
                savedSearchResultView.setSearchResultViewColumns(searchResultViewColumns);
                Set<SearchSQLGroup> searchSQLGroups = this.fillSearchSQLGroupParents(searchResultView.getSearchSQLGroups(), savedSearchResultView);
                savedSearchResultView.setSearchSQLGroups(searchSQLGroups);
                this.searchResultViewDAO.merge(savedSearchResultView);
            }
            catch (Exception e) {
                e.printStackTrace();
                nonExecutedViews.add(searchResultViewDTO.getViewCode());
            }
        }
    }

    private Set<SearchSQLGroup> fillSearchSQLGroupParents(Set<SearchSQLGroup> searchSQLGroups, SearchResultView savedSearchResultView) {
        for (SearchSQLGroup searchSQLGroup : searchSQLGroups) {
            searchSQLGroup.setSearchResultView(savedSearchResultView);
        }
        return searchSQLGroups;
    }

    private Set<SearchResultViewColumn> fillSearchResultViewColumnParents(Set<SearchResultViewColumn> searchResultViewColumns, SearchResultView savedSearchResultView) {
        for (SearchResultViewColumn searchResultViewColumn : searchResultViewColumns) {
            searchResultViewColumn.setSearchResultView(savedSearchResultView);
        }
        return searchResultViewColumns;
    }

    private Map<String, SearchConfigTable> buldSearchConfigTablesMapForView(SearchResultView savedSearchResultView) {
        HashMap<String, SearchConfigTable> searchConfigTablesMap = new HashMap<String, SearchConfigTable>();
        Set<SearchConfigTable> searchConfigTables = savedSearchResultView.getSearchConfiguration().getSearchConfigurationTables();
        for (SearchConfigTable searchConfigTable : searchConfigTables) {
            searchConfigTablesMap.put(searchConfigTable.getAlias(), searchConfigTable);
        }
        return searchConfigTablesMap;
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public List<CustomField> findAllCustomFields() {
        return this.searchConfigDAO.findAllCustomFields();
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void updateStandardMasterColumns() {
        this.searchConfigDAO.updateStandardMasterColumns();
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void disableSortingForAggregateColumns() {
        this.searchConfigDAO.disableSortingForAggregateColumns();
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void disableSortingForAggregateColumns(String viewCode) {
        this.searchConfigDAO.disableSortingForAggregateColumns(viewCode);
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public SearchConfigIdModel getSearchConfigModel(String configCode) {
        SearchConfigIdModel model = new SearchConfigIdModel();
        model.setSearchConfigId(this.searchConfigDAO.findIdByConfigCode(configCode));
        return model;
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void deleteOldSearchConfigData(SearchConfigIdModel searchConfigIdModel) {
        this.searchConfigDAO.deleteOldSearchConfigData(searchConfigIdModel);
    }
}

