/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.sm.service.impl;

import in.serosoft.content.loginPageContentUtility.LoginPageContentConfigurationApp;
import in.serosoft.sm.dao.LoginPageContentUtilityDAO;
import in.serosoft.sm.service.LoginPageContentUtilityService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="loginPageContentUtilityService")
public class LoginPageContentUtilityServiceImpl
implements LoginPageContentUtilityService {
    @Autowired
    LoginPageContentUtilityDAO loginPageContentUtilityDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void generateContentFile() {
        Map<String, String> loginPageContentDataLst = this.loginPageContentUtilityDAO.getLoginPageContentData();
        BufferedReader bufferReader = null;
        BufferedWriter bufferWriter = null;
        File fileLocation = new File(LoginPageContentConfigurationApp.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        String[] filePath = fileLocation.getPath().split("CriteriaBuilderConfigurer");
        String path1 = filePath[0].replace("%20", " ");
        try {
            String strCurrentLine;
            File constantFileLoc = new File(path1 + "serosoft-academia-parent/serosoft-academia-web/src/main/webapp/resources/js/constants.js");
            bufferReader = new BufferedReader(new FileReader(constantFileLoc));
            File file = new File(path1 + "serosoft-academia-parent/serosoft-academia-web/src/main/webapp/resources/js/constantscopy.js");
            if (!file.exists()) {
                file.createNewFile();
            } else {
                Path path = Paths.get(path1 + "serosoft-academia-parent/serosoft-academia-web/src/main/webapp/resources/js/constantscopy.js", new String[0]);
                this.cleanUp(path);
                file.createNewFile();
            }
            bufferWriter = new BufferedWriter(new FileWriter(file));
            Set<String> pageNameLst = null;
            while ((strCurrentLine = bufferReader.readLine()) != null) {
                if (strCurrentLine.contains("PAGE:{")) {
                    pageNameLst = loginPageContentDataLst.keySet();
                    int pageContentCount = pageNameLst.size();
                    int count = 1;
                    bufferWriter.write("PAGE:{\n");
                    for (String pageContent : pageNameLst) {
                        if (pageContentCount == count) {
                            bufferWriter.write(pageContent + ":" + loginPageContentDataLst.get(pageContent).replace("\\\\", "\\") + "\n}\n};");
                        } else {
                            bufferWriter.write(pageContent + ":" + loginPageContentDataLst.get(pageContent).replace("\\\\", "\\") + ",\n");
                        }
                        ++count;
                    }
                    continue;
                }
                if (pageNameLst != null) continue;
                bufferWriter.write(strCurrentLine + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferWriter != null) {
                    bufferWriter.close();
                }
                if (bufferReader != null) {
                    bufferReader.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        try {
            File f1 = new File(path1 + "serosoft-academia-parent/serosoft-academia-web/src/main/webapp/resources/js/constants.js");
            File f2 = new File(path1 + "serosoft-academia-parent/serosoft-academia-web/src/main/webapp/resources/js/constantscopy.js");
            LoginPageContentUtilityServiceImpl.copyFileUsingStream(f2, f1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanUp(Path path) throws NoSuchFileException, DirectoryNotEmptyException, IOException {
        Files.delete(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileUsingStream(File source, File dest) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }
}

