CREATE TABLE IF NOT EXISTS `file_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `file_info_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `fileTypeId` bigint(20) DEFAULT NULL,
  `fileNumber` varchar(255) DEFAULT NULL,
  `fileSubject` varchar(255) DEFAULT NULL,
  `fileOwner` bigint(20) DEFAULT NULL,
  `creationDate` datetime DEFAULT NULL,
  `dueDate` datetime DEFAULT NULL,
  `priority` bigint(20) DEFAULT NULL,
  `otherDetail` TEXT DEFAULT NULL,
  `remarks` TEXT DEFAULT NULL,
  `currentStatus` varchar(20) DEFAULT NULL,
  `updateReason` TEXT DEFAULT NULL,
  `statusChangeDate` datetime DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `file_academy_location_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `fileId` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `file_document_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `fileId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `uploadedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `file_assignment_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `fileId` bigint(20) NOT NULL,
  `assignedUser` bigint(20) NOT NULL,
  `assignmentDate` datetime NOT NULL,
  `dueDate` datetime DEFAULT NULL,
  `remarks` TEXT DEFAULT NULL,
  `fileStatus` varchar(20) DEFAULT NULL,
  `acknowledgement` varchar(20) DEFAULT NULL,
  `fileHandoverBy` bigint(20) NOT NULL,
  `receivedDate` datetime DEFAULT NULL,
  `returnReason` TEXT DEFAULT NULL,
  `returnDate` datetime DEFAULT NULL,
  `resubmissionDueDate` datetime DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
