DELIMITER $$

DROP PROCEDURE IF EXISTS V202001022040__AlterColumnPlacmentCampusHistory $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001022040__AlterColumnPlacmentCampusHistory()

BEGIN
 
 -- Add the email_address column to the email table, if it doesn't already exist
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='placement_campus_history'
 AND column_name ='whetherAllowed')) THEN
 
  ALTER TABLE `placement_campus_history`
   ADD COLUMN `whetherAllowed` BIT(1) NULL DEFAULT b'1' AFTER `whetherDocumentRequired`;

 END IF;

END $$

-- Execute the stored procedure
CALL V202001022040__AlterColumnPlacmentCampusHistory() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001022040__AlterColumnPlacmentCampusHistory $$

DELIMITER ;