DELIMITER $$

DROP PROCEDURE IF EXISTS V20200311114637__Create_ReviewParameterHistory $$

CREATE PROCEDURE V20200311114637__Create_ReviewParameterHistory()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='review_parameter_history')) THEN 

		CREATE TABLE `review_parameter_history` (
		`id` bigint(20) NOT NULL AUTO_INCREMENT,
		`REV` bigint(20) NOT NULL,
  		`REVTYPE` tinyint(4) DEFAULT NULL,
		`itemCode` varchar(255) NOT NULL,
		`itemValue` varchar(255) NOT NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
		PRIMARY KEY (`id`,`REV`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='review_parameter_rating_history')) THEN 

		CREATE TABLE `review_parameter_rating_history` (
  		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  		`REV` bigint(20) NOT NULL,
  		`REVTYPE` tinyint(4) DEFAULT NULL,
  		`reviewParameterId` BIGINT(20) NULL,
  		`itemCode` varchar(255) NOT NULL,
		`itemValue` varchar(255) NOT NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
		PRIMARY KEY (`id`,`REV`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	END IF; 

END $$

CALL V20200311114637__Create_ReviewParameterHistory () $$

DROP PROCEDURE IF EXISTS V20200311114637__Create_ReviewParameterHistory $$

DELIMITER ;