DELIMITER $$

DROP PROCEDURE IF EXISTS V20200817141102__Alter_AppPersonHistoryAddColumns $$

CREATE PROCEDURE V20200817141102__Alter_AppPersonHistoryAddColumns()

BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person_history' AND column_name='isMilitarySponsored')) THEN 
  ALTER TABLE `applicant_person_history` 
  ADD COLUMN `isMilitarySponsored` BIT(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person_history' AND column_name='isBursaryRequirements')) THEN 
  ALTER TABLE `applicant_person_history` 
  ADD COLUMN `isBursaryRequirements` BIT(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person_history' AND column_name='pHDSponsor')) THEN 
  ALTER TABLE `applicant_person_history` 
  ADD COLUMN `pHDSponsor` VARCHAR(100) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person_history' AND column_name='fieldOfInterest')) THEN 
  ALTER TABLE `applicant_person_history` 
  ADD COLUMN `fieldOfInterest` BIGINT(20) NULL DEFAULT NULL,
  ADD INDEX `fk_applicant_person_fieldOfInterest_idx` (`fieldOfInterest` ASC);
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person_history' AND column_name='areaOfResearch')) THEN 
  ALTER TABLE `applicant_person_history` 
  ADD COLUMN `areaOfResearch` BIGINT(20) NULL DEFAULT NULL,
  ADD INDEX `fk_applicant_person_areaOfResearch_idx` (`areaOfResearch` ASC);
END IF; 

END $$

CALL V20200817141102__Alter_AppPersonHistoryAddColumns() $$

DROP PROCEDURE IF EXISTS V20200817141102__Alter_AppPersonHistoryAddColumns $$

DELIMITER ;