DELIMITER $$

DROP PROCEDURE IF EXISTS V20201006203640__CreateMaritalStatusAudit $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20201006203640__CreateMaritalStatusAudit()

BEGIN
  
  IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='marital_status_history' )) THEN
  
  CREATE TABLE `marital_status_history` (
		  `id` bigint(20) NOT NULL,
		  `REV` bigint(20) NOT NULL,
		  `REVTYPE` tinyint(4) DEFAULT NULL,
		  `itemCode` varchar(255) DEFAULT NULL,
		  `itemValue` varchar(255) DEFAULT NULL,
		  `isDeletable` BIT(1) NOT NULL DEFAULT 1,
		  `isEditable` BIT(1) NOT NULL DEFAULT 1,
		  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `lastUpdatedBy` bigint(20) NOT NULL,
		  PRIMARY KEY (`id`,`REV`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF;

END $$

-- Execute the stored procedure
CALL V20201006203640__CreateMaritalStatusAudit() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20201006203640__CreateMaritalStatusAudit $$
 
DELIMITER ;
