DELIMITER $$
DROP PROCEDURE IF EXISTS V20201104211353__Create_ElectionHistory $$
CREATE PROCEDURE V20201104211353__Create_ElectionHistory()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='election_history')) THEN 
CREATE TABLE `election_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `electionCode` VARCHAR(255) NOT NULL,
  `electionTypeId` BIGINT(20) NOT NULL,
  `electionName` VARCHAR(255) NOT NULL,
  `electionNameInOtherLanguage` VARCHAR(255) NULL,
  `academicTermId` BIGINT(20) NOT NULL,
  `isAdminCaptureVote` BIT(1) NULL,
  `votingStartDate` DATE NOT NULL,
  `votingStartTime` DATETIME NOT NULL,
  `votingEndDate` DATE NOT NULL,
  `votingEndTime` DATETIME NOT NULL,
  `adminCaptureStartDate` DATE NULL,
  `adminCaptureStartTime` DATETIME NULL,
  `adminCaptureEndDate` DATE NULL,
  `adminCaptureEndTime` DATETIME NULL,
  `isReferendumOne` BIT(1) NULL,
  `referendumOneQuestionInEnglish` TEXT NULL,
  `referendumOneQuestionInOtherLang` TEXT NULL,
  `isReferendumTwo` BIT(1) NULL,
  `referendumTwoQuestionInEnglish` TEXT NULL,
  `referendumTwoQuestionInOtherLang` TEXT NULL,
  `electionDescriptionInEnglish` TEXT NOT NULL,
  `electionDescriptionInOtherLang` TEXT NULL,
  `isActive` BIT(1) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
   PRIMARY KEY (id, REV));

END IF; 

END $$
CALL V20201104211353__Create_ElectionHistory () $$ 
DROP PROCEDURE IF EXISTS V20201104211353__Create_ElectionHistory $$ 
DELIMITER ;