DELIMITER $$

DROP PROCEDURE IF EXISTS V20210115183738__CreateTVETReportDownloadRequestAudit $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210115183738__CreateTVETReportDownloadRequestAudit()
BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='tvet_report_download_request_history' )) THEN
    
	CREATE TABLE `tvet_report_download_request_history` (
	  `id` bigint(20) NOT NULL,
	  `REV` int(11) NOT NULL,
	  `REVTYPE` tinyint(4) DEFAULT NULL,
	  `requestBy` bigint DEFAULT NULL,
	  `requestTime` datetime DEFAULT NULL,
	  `noOfFiles` int DEFAULT NULL,
	  `requestStatus` varchar(45) DEFAULT NULL,
	  `errorMsg` text,
	  `fileLink` text,
	  `lastUpdate` timestamp NULL DEFAULT NULL,
	  `lastUpdatedBy` bigint DEFAULT NULL,
	  PRIMARY KEY (`id`,`REV`)
	);
	
  END IF ;
  
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='tvet_report_download_request_file_history' )) THEN
    
	CREATE TABLE `tvet_report_download_request_file_history` (
	  `id` bigint(20) NOT NULL,
	  `REV` int(11) NOT NULL,
	  `REVTYPE` tinyint(4) DEFAULT NULL,
	  `trdrId` bigint DEFAULT NULL,
	  `reportId` bigint DEFAULT NULL,
	  `noOfRecords` int DEFAULT NULL,
	  `isSuccess` bit(1) DEFAULT NULL,
	  `lastUpdate` timestamp NULL DEFAULT NULL,
	  `lastUpdatedBy` bigint DEFAULT NULL,
	  PRIMARY KEY (`id`,`REV`)
	);
	
  END IF ;

END $$

-- Execute the stored procedure
CALL V20210115183738__CreateTVETReportDownloadRequestAudit $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210115183738__CreateTVETReportDownloadRequestAudit $$
 
DELIMITER ;