DELIMITER $$
DROP PROCEDURE IF EXISTS V20220718125757__Create_examDaysToSKipHistory $$
CREATE PROCEDURE V20220718125757__Create_examDaysToSKipHistory()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='eval_group_days_to_skip_history' )) THEN 
CREATE TABLE `eval_group_days_to_skip_history` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `evaluationGroupId` BIGINT NOT NULL,
  `weekday` VARCHAR(100) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`),
  INDEX `evalGroup_lastUpdateBy` (`lastUpdatedBy` ASC) ,
  INDEX `evalGroup_EvaluationGroup` (`evaluationGroupId` ASC) ,
  CONSTRAINT `evalGroup_c_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users_history` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
CONSTRAINT `evalGroup_c_EvaluationGroup`
	FOREIGN KEY (`evaluationGroupId`)
	REFERENCES `evaluation_group_history` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);
END IF; 


END $$
CALL V20220718125757__Create_examDaysToSKipHistory () $$ 
DROP PROCEDURE IF EXISTS V20220718125757__Create_examDaysToSKipHistory $$ 
DELIMITER ;