DELIMITER $$
DROP PROCEDURE IF EXISTS V20250521000752__Alter_AddReasonForProgramTransferHistory $$
CREATE PROCEDURE V20250521000752__Alter_AddReasonForProgramTransferHistory()
BEGIN

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'program_transfer_request_multiple_reason_history' 
      AND COLUMN_NAME = 'programTransferReasonCsmId'
) THEN
    ALTER TABLE program_transfer_request_multiple_reason_history
    ADD COLUMN programTransferReasonCsmId BIGINT DEFAULT NULL;
END IF;

SET SQL_SAFE_UPDATES=0;
UPDATE program_transfer_request_multiple_reason_history AS ptrmr
JOIN program_transfer_request_multiple_reason_history AS ptrmrself
ON ptrmrself.programTransferRequestDetailId = ptrmr.programTransferRequestDetailId
SET ptrmr.programTransferReasonCsmId = ptrmrself.programTransferReasonId;
SET SQL_SAFE_UPDATES=1; 

END $$
CALL V20250521000752__Alter_AddReasonForProgramTransferHistory() $$
DROP PROCEDURE IF EXISTS V20250521000752__Alter_AddReasonForProgramTransferHistory $$
DELIMITER ;