DELIMITER $$
DROP PROCEDURE IF EXISTS V20251225183720__Create_exam_block_history $$
CREATE PROCEDURE V20251225183720__Create_exam_block_history()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_block_history')) THEN 
create table `exam_block_history` (
  `id` bigint not null,
  `REV` bigint not null,
  `REVTYPE` tinyint default null,
  `code` varchar(255) not null,
  `name` varchar(255) not null,
  `examCenterId` bigint not null,
  `fromDate` datetime not null,
  `tillDate` datetime not null,
  `studentCanSelectCenter` BOOLEAN DEFAULT FALSE,
  `onlineExamApplicable` BOOLEAN DEFAULT FALSE,
  `status` BOOLEAN DEFAULT FALSE,
  `lastUpdate` timestamp not null default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	`lastUpdatedBy` bigint not null,
	 primary key (`id`,`REV`)) engine = INNODB;
END IF; 

END $$
CALL V20251225183720__Create_exam_block_history () $$ 
DROP PROCEDURE IF EXISTS V20251225183720__Create_exam_block_history $$ 
DELIMITER ;