CREATE TABLE `faculty_program_attendance` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `programId` bigint(20) NOT NULL,
  `batchId` bigint(20) NOT NULL,
  `periodId` bigint(20) NOT NULL,
  `sectionId` bigint(20) NOT NULL,
  `dateOfAttendance` date NOT NULL,
  `attendanceType` varchar(20) NOT NULL,
  `fromTime` time DEFAULT NULL,
  `toTime` time DEFAULT NULL,
  `facultyId` bigint(20) NOT NULL,
  `attendanceStatus` varchar(25) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refprograms202_faculty` (`programId`),
  KEY `Refbatches203_faculty` (`batchId`),
  KEY `Refsections510_faculty` (`sectionId`),
  KEY `Refusers1465_faculty` (`lastUpdatedBy`),
  KEY `Ref_period_idx_faculty` (`periodId`),
  KEY `Ref_faculty_idx_faculty` (`facultyId`),
  CONSTRAINT `Refusers1465_faculty` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `Ref_batch_faculty` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_faculty_faculty` FOREIGN KEY (`facultyId`) REFERENCES `faculties` (`personId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_period_faculty` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_program_faculty` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_sections_faculty` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
);
