SET FOREIGN_KEY_CHECKS=0;
DROP TABLE IF exists `examination_result`;
CREATE TABLE `examination_result` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationDetailSequenceId` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `questionPaperId` bigint(20) DEFAULT NULL,
  `whetherRevaluation` bit(1) NOT NULL,
  `whetherMalpracticeReported` bit(1) DEFAULT NULL,
  `totalMarksGiven` float DEFAULT NULL,
  `graceMarksGiven` float DEFAULT NULL,
  `penultyMarksGiven` float DEFAULT NULL,
  `netMarksGiven` float DEFAULT NULL,
  `finalMarks` int(11) DEFAULT NULL,
  `finalGrade` varchar(4) DEFAULT NULL,
  `finalDescription` varchar(255) DEFAULT NULL,
  `gradePoints` float DEFAULT NULL,
  `examResultStatus` varchar(45) DEFAULT NULL COMMENT 'PASS/FAIL',
  `examinorRemark` varchar(255) DEFAULT NULL,
  `reviewerRemark` varchar(255) DEFAULT NULL,
  `revaluerRemark` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'PASS/FAIL',
  PRIMARY KEY (`id`),
  KEY `Refadmission738` (`admissionId`),
  KEY `Refquestion_paper740` (`questionPaperId`),
  KEY `Refusers1296` (`lastUpdatedBy`),
  KEY `Refeval_seq_detail1700` (`evaluationDetailSequenceId`),
  CONSTRAINT `Refadmission738` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `Refeval_seq_detail1700` FOREIGN KEY (`evaluationDetailSequenceId`) REFERENCES `eval_seq_detail` (`id`),
  CONSTRAINT `Refquestion_paper740` FOREIGN KEY (`questionPaperId`) REFERENCES `question_paper` (`id`),
  CONSTRAINT `Refusers1296` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
SET FOREIGN_KEY_CHECKS=1;