SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS dydt_sql_query_conf;

DROP TABLE IF EXISTS dydt_template_conf;
DROP TABLE IF EXISTS dydt_owner_conf;

DROP TABLE IF EXISTS dydt_data_line_item;
DROP TABLE IF EXISTS dydt_document_data_provider;
DROP TABLE IF EXISTS dydt_data_provider_param;
DROP TABLE IF EXISTS dydt_data_provider;

DROP TABLE IF EXISTS dydt_document_type;
DROP TABLE IF EXISTS dydt_document_param;

DROP TABLE IF EXISTS dydt_template_data_query; 

CREATE TABLE `dydt_data_provider` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `providerName` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `dydt_document_param` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paramCode` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `dydt_data_provider_param` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parameterId` bigint(20) NOT NULL,
  `typeCode` varchar(3) NOT NULL,
  `providerId` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parameterId` (`parameterId`),
  KEY `providerId` (`providerId`),
  CONSTRAINT `dydt_data_provider_param_ibfk_1` FOREIGN KEY (`parameterId`) REFERENCES `dydt_document_param` (`id`),
  CONSTRAINT `dydt_data_provider_param_ibfk_2` FOREIGN KEY (`providerId`) REFERENCES `dydt_data_provider` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `dydt_document_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `typeName` varchar(100) NOT NULL,
  `configLevelCode` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;



CREATE TABLE `dydt_data_line_item` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `dataProviderId` bigint(20) NOT NULL,
  `dataSourceCode` varchar(50) DEFAULT NULL,
  `executionOrder` int(11) NOT NULL,
  `publishAsParametersDef` text,
  `whetherDataSource` tinyint(4) NOT NULL,
  `whetherPrimaryDataSource` tinyint(4) NOT NULL,
  `sqlSelectQueryDef` text,
  `whereClauseBindingDef` text,
  `resultColumnsDef` text,
  `formattersDef` text,
  `sqlWhereQueryDef` text,
  `whetherMultiRecord` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`,`whetherPrimaryDataSource`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;


CREATE TABLE `dydt_document_data_provider` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `dataProviderId` bigint(20) NOT NULL,
  `executionOrder` int(11) NOT NULL,
  `documentTypeId` bigint(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dataProviderId` (`dataProviderId`),
  KEY `documentTypeId` (`documentTypeId`),
  CONSTRAINT `dydt_document_data_provider_ibfk_1` FOREIGN KEY (`dataProviderId`) REFERENCES `dydt_data_provider` (`id`),
  CONSTRAINT `dydt_document_data_provider_ibfk_2` FOREIGN KEY (`documentTypeId`) REFERENCES `dydt_document_type` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `dydt_template_conf` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentTypeId` bigint(20) NOT NULL,
  `templateName` varchar(150) NOT NULL,
  `templateType` varchar(50) NOT NULL,
  `whetherDefault` tinyint(4) DEFAULT NULL,
  `previewImage` blob,
  `repeatHeader` tinyint(4) DEFAULT NULL,
  `repeatFooter` tinyint(4) DEFAULT NULL,
  `reportParams` text,
  `templateContent` text,
  `mainReportPath` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `dydt_owner_conf` (
  `id` bigint(20) NOT NULL,
  `documentTypeId` bigint(20) NOT NULL,
  `ownerId` bigint(20) NOT NULL,
  `templateId` bigint(20) NOT NULL,
  `useDefaultTemplate` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `documentTypeId` (`documentTypeId`),
  KEY `templateId` (`templateId`),
  CONSTRAINT `dydt_owner_conf_ibfk_1` FOREIGN KEY (`documentTypeId`) REFERENCES `dydt_document_type` (`id`),
  CONSTRAINT `dydt_owner_conf_ibfk_2` FOREIGN KEY (`templateId`) REFERENCES `dydt_template_conf` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



SET FOREIGN_KEY_CHECKS=1;



