CREATE TABLE `voucher` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `voucherID` varchar(255) DEFAULT NULL,
  `voucherDate` date DEFAULT NULL,
  `createdFrom` varchar(45) DEFAULT NULL COMMENT 'Bill/Receipt/Payment Voucher',
  `billType` varchar(45) DEFAULT NULL COMMENT 'Debit/Credit',
  `receiptType` varchar(45) DEFAULT NULL COMMENT 'Scholarship/Fees',
  `paymentType` varchar(45) DEFAULT NULL COMMENT 'Refunds/Services provided',
  `voucherStatus` varchar(45) DEFAULT NULL COMMENT 'created/Posted/Updated',
  `accountingReference` varchar(255) DEFAULT NULL,
  `voucherType` varchar(45) DEFAULT NULL COMMENT 'individual/consolidated',
  `voucherMode` varchar(45) DEFAULT NULL COMMENT 'JV/Cash Receipt/Bank Receipt/Cash Payment/Bank Payment',
  `consolidationDate` date DEFAULT NULL,
  `postingDate` date DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  `totalAmount` double(20,2) DEFAULT NULL COMMENT 'Bill/Receipt/Payment Amount-Total',
  `voucherAmount` double(20,2) DEFAULT NULL,
  `voucherNarration` text,
  `vouchercurrencyId` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `voucherFlag` varchar(45) DEFAULT NULL COMMENT 'Original/Reversal',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefIauFK323_idx` (`iauId`),
  KEY `RefCurrencyFk34_idx` (`currencyId`),
  KEY `RefVouchercurrencyFK345_idx` (`vouchercurrencyId`),
  KEY `RefusersFK2333_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefusersFK2333` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefCurrencyFk34` FOREIGN KEY (`currencyId`) REFERENCES `currency` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefIauFK323` FOREIGN KEY (`iauId`) REFERENCES `organization_units` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefVouchercurrencyFK345` FOREIGN KEY (`vouchercurrencyId`) REFERENCES `currency` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE `voucher_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `voucherId` bigint(20) NOT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  `controlAccountKey` varchar(255) DEFAULT NULL,
  `subLedgerAccountKey` varchar(255) DEFAULT NULL,
  `debit` double(20,2) DEFAULT NULL,
  `credit` double(20,2) DEFAULT NULL,
  `narration` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefVoucherFk12_idx` (`voucherId`),
  KEY `RefConfigcontrolFK1_idx` (`configControlAccountId`),
  KEY `RefUsersFK89_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefUsersFK89` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefConfigcontrolFK1` FOREIGN KEY (`configControlAccountId`) REFERENCES `config_control_account` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefVoucherFk12` FOREIGN KEY (`voucherId`) REFERENCES `voucher` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE `account_balances` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `iauId` bigint(20) DEFAULT NULL,
  `controlAccountKey` varchar(255) DEFAULT NULL,
  `subLedgerAccountKey` varchar(255) DEFAULT NULL,
  `accountType` varchar(45) DEFAULT NULL COMMENT 'income/expense/asset/liability',
  `transactionDate` date DEFAULT NULL,
  `accountingYear` varchar(45) DEFAULT NULL,
  `debitTotal` double(20,2) DEFAULT NULL,
  `creditTotal` double(20,2) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefIauFK23_idx` (`iauId`),
  KEY `RefUsers897_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefIauFK23` FOREIGN KEY (`iauId`) REFERENCES `organization_units` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefUsersFK8971` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE `iau_batch_import` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `iauId` bigint(20) DEFAULT NULL,
  `batchImportDate` date DEFAULT NULL,
  `totalAccountImported` bigint(20) DEFAULT NULL,
  `totalSubledgerImported` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefIauFK87_idx` (`iauId`),
  KEY `RefUsersFK765_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefUsersFK765` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefIauFK87` FOREIGN KEY (`iauId`) REFERENCES `organization_units` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `iau_batch_posting` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `iauId` bigint(20) DEFAULT NULL,
  `batchPostingDate` date DEFAULT NULL,
  `vouchersPosted` bigint(20) DEFAULT NULL,
  `voucherFailed` bigint(20) DEFAULT NULL,
  `totalAmountPosted` double(20,2) DEFAULT NULL,
  `totalAmountFailed` double(20,2) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefIauFK76_idx` (`iauId`),
  KEY `RefUsersFK87_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefIauFK76` FOREIGN KEY (`iauId`) REFERENCES `organization_units` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefUsersFK87` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

