CREATE TABLE `attendance_machine` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`machineName` VARCHAR(255) NOT NULL,
	`machineIP` VARCHAR(255) NOT NULL,
	`description` VARCHAR(255) DEFAULT NULL,  
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);

CREATE TABLE `attendance_machine_location`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`attendanceMachineId` BIGINT(20) NOT NULL,
	`locationId` BIGINT(20) NOT NULL,
	`activeTillDate` TIMESTAMP NULL COMMENT 'NULL, if machine is active on a location, NOT NULL, if machine is not active on a location',
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`attendanceMachineId`) REFERENCES `attendance_machine`(`id`),
	FOREIGN KEY (`locationId`) REFERENCES `resources`(`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);

CREATE TABLE `attendance_machine_log` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`attendanceMachineLocationId` BIGINT(20) NOT NULL,
	`userId` BIGINT(20) NOT NULL,
	`punchTime` TIMESTAMP NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`attendanceMachineLocationId`) REFERENCES `attendance_machine_location`(`id`),
	FOREIGN KEY (`userId`) REFERENCES `users`(`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);