ALTER TABLE `marksheet_job_details` 
ADD COLUMN `isPublishMarksheet` BIT(1) NOT NULL DEFAULT b'0' COMMENT '' AFTER `lastUpdate`;


CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `student_period_report` AS
    SELECT 
        `admission`.`id` AS `admissionId`,
        `admission`.`studentId` AS `studentId`,
        `evaluation_period_rank`.`id` AS `periodRankId`,
        `admission`.`code` AS `admissionCode`,
        `programs`.`id` AS `programId`,
        `programs`.`programName` AS `programName`,
        `batches`.`id` AS `batchId`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `prog_batch_period_config`.`programPeriodName` AS `periodName`,
        `sections`.`id` AS `sectionId`,
        `sections`.`sectionCode` AS `sectionName`,
        COUNT(DISTINCT `student_course_enrollment`.`courseVarientId`) AS `totalNoOfCourse`,
        COUNT(DISTINCT (CASE
                WHEN (`student_course_enrollment`.`whetherOptional` = 0) THEN `student_course_enrollment`.`courseVarientId`
            END)) AS `mandatoryCourseCount`,
        COUNT(DISTINCT (CASE
                WHEN (`student_course_enrollment`.`whetherOptional` = 1) THEN `student_course_enrollment`.`courseVarientId`
            END)) AS `optionalCourseCount`,
        (CASE
            WHEN ISNULL(`evaluation_period_rank`.`obtainedMarks`) THEN `evaluation_period_rank`.`sgpa`
            ELSE `evaluation_period_rank`.`obtainedMarks`
        END) AS `SGPAORMarks`,
        `evaluation_period_rank`.`status` AS `ResultStatus`,
        (CASE WHEN marksheet_job_details.isPublishMarksheet THEN `marksheet_job_details`.`marksheetPath` END)
         AS `marksheetPath`
    FROM
        ((((((((`program_batch_students`
        LEFT JOIN `admission` ON ((`program_batch_students`.`admissionId` = `admission`.`id`)))
        LEFT JOIN `prog_batch_period_config` ON ((`program_batch_students`.`progBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        LEFT JOIN `batches` ON ((`program_batch_students`.`programBatchId` = `batches`.`id`)))
        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        LEFT JOIN `evaluation_period_rank` ON (((`evaluation_period_rank`.`admissionId` = `admission`.`id`)
            AND (`evaluation_period_rank`.`periodId` = `prog_batch_period_config`.`id`))))
        LEFT JOIN `student_course_enrollment` ON ((`student_course_enrollment`.`admissionId` = `admission`.`id`)))
        LEFT JOIN `sections` ON ((`student_course_enrollment`.`sectionId` = `sections`.`id`)))
        LEFT JOIN `marksheet_job_details` ON (((`marksheet_job_details`.`admissionId` = `admission`.`id`)
            AND (`marksheet_job_details`.`periodId` = `prog_batch_period_config`.`id`))))
    GROUP BY `prog_batch_period_config`.`id` , `admission`.`id`;
