set sql_safe_updates=0;

update
bill_header
LEFT JOIN bill_fee_plan_rule_stage ON bill_header.id = bill_fee_plan_rule_stage.billId
LEFT JOIN fee_stage_head_config ON bill_fee_plan_rule_stage.feeStageHeadConfigId = fee_stage_head_config.id
LEFT JOIN fee_heads ON fee_stage_head_config.feeHeadId = fee_heads.id
LEFT JOIN students ON bill_header.studentId = students.userId
LEFT JOIN admission ON students.userId = admission.studentId
LEFT JOIN fee_plan_rule_stage ON fee_stage_head_config.feePlanRuleStageId = fee_plan_rule_stage.id
LEFT JOIN fee_plan_rules ON fee_plan_rule_stage.feePlanRuleId = fee_plan_rules.id
LEFT JOIN fee_plan ON fee_plan_rules.feePlanId = fee_plan.id
LEFT JOIN fee_plan_acad_locations ON fee_plan.id = fee_plan_acad_locations.feePlanId
AND admission.programBatchSeatConfigId = fee_plan_acad_locations.progBatchSeatConfigId
LEFT JOIN prog_batch_seat_config ON fee_plan_acad_locations.progBatchSeatConfigId = prog_batch_seat_config.id
set bill_header.programBatchSeatConfigId=prog_batch_seat_config.id
WHERE
bill_header.studentId IS NOT NULL
and bill_header.applicantId is NULL;

update
bill_header
LEFT JOIN bill_fee_plan_rule_stage ON bill_header.id = bill_fee_plan_rule_stage.billId
LEFT JOIN fee_stage_head_config ON bill_fee_plan_rule_stage.feeStageHeadConfigId = fee_stage_head_config.id
LEFT JOIN fee_heads ON fee_stage_head_config.feeHeadId = fee_heads.id
LEFT JOIN application ON bill_header.applicantId = application.id
LEFT JOIN application_program ON application.id = application_program.applicationId
LEFT JOIN applicant_person ON application.applicantPersonId = applicant_person.id
LEFT JOIN fee_plan_rule_stage ON fee_stage_head_config.feePlanRuleStageId = fee_plan_rule_stage.id
LEFT JOIN fee_plan_rules ON fee_plan_rule_stage.feePlanRuleId = fee_plan_rules.id
LEFT JOIN fee_plan ON fee_plan_rules.feePlanId = fee_plan.id
LEFT JOIN fee_plan_acad_locations ON fee_plan.id = fee_plan_acad_locations.feePlanId
AND application_program.progBatchSeatConfigId = fee_plan_acad_locations.progBatchSeatConfigId
LEFT JOIN prog_batch_seat_config ON fee_plan_acad_locations.progBatchSeatConfigId = prog_batch_seat_config.id
set bill_header.programBatchSeatConfigId=prog_batch_seat_config.id
WHERE
bill_header.applicantId IS NOT NULL;

set sql_safe_updates=0;