CREATE TABLE `external_users` 
(
   `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
   `loginId` VARCHAR(50) NOT NULL,
   `emailId` VARCHAR(100) DEFAULT NULL,
   `salt` VARCHAR(50) NOT NULL,
   `password` VARCHAR(100) NOT NULL,
   `userType` VARCHAR(25) NOT NULL,
   `lastUpdatedBy` BIGINT(20) DEFAULT NULL,
   `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   `whetherActive` TINYINT(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ;

CREATE TABLE `external_user_association` 
(
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
   `externalUserId` BIGINT(20) NOT NULL,
   `referencyEntityType` VARCHAR(25) NOT NULL,
   `applicationId` BIGINT(20) DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `applicationId` (`applicationId`),
CONSTRAINT `external_user_association_ibfk_1` FOREIGN KEY (`externalUserId`) REFERENCES `external_users` (`id`),
CONSTRAINT `external_user_association_ibfk_2` FOREIGN KEY (`applicationId`) REFERENCES `application` (`id`)
);

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

INSERT INTO `users` ( `code`, `firstName`, `middleName`, `lastName`, `shortName`, `printName`,
 `calendarId`, `whetherSystemUser`, `password`, `salt`, `ipAddress`, 
 `lockedOn`, `status`, `lockedStatus`, `lockedReason`, `noOfTimesLocked`, `noOfLoginFailed`, 
 `lastLockReleaseDate`, `totalAutoLogout`, `whetherDeleted`, `totalLoginFailed`, `accountingKey`,
  `userGroupId`, `whetherInternal`, `lastUpdatedBy`, `lastUpdate`, `version`, `whetherPasswordReset`, 
  `inactiveReasonCode`, `temporaryInActive`, `passwordLastUpdated`) VALUES 
('PUBLIC_PORTAL_USER', 'PUBFIRST_NAME', 'PUBMIDDLE_NAME', 'PUB_LAST_NAME', 'PUBLICPORTAL', 'PUBLICPORTAL', 
'1', '\0', 'a8c4b282178bfa90b4bc73abfe110a1801e5f85f9ff33efb964ef1343b4211aa', ".,\'57;*PSF<K9KDV\'QY@*3EF9.95480", NULL, 
@currentTimeStamp, 1, 0, NULL, '0', '0', 
NULL, NULL, 0, 1, NULL, 
'2', 1, '1', @currentTimeStamp, '4', 0, 
NULL, 0, @currentTimeStamp);

SET @ItemsMaxUserId=(SELECT MAX(id) FROM users);

INSERT INTO `persons` ( `mobileNumber`, `mobileCountryCode`, `phoneNo`, `phoneCountryCode`, `phoneAreaCode`, `employeeId`, 
`firstName`, `middleName`, `emailId`, `lastName`, `shortName`, `birthDate`, 
`bloodGroup`, `bankDetailId`, `gender`,`maritalStatus`, `category`, `occupation`, `personalIncome`, 
`photoUrl`, `salutationId`, `castCategoryId`, `nationalityId`, `whetherEmployeeOfOrganization`, `whetherDeleted`, `lastUpdatedBy`, `lastUpdate`, 
`version`, `countryId`, `printName`,`religionId`, `physicalCharacteristicId`) 
VALUES ( NULL, NULL, NULL, NULL, NULL, NULL, 
'PUBLICPERSON', NULL, NULL, 'PUBLICPERSON', NULL, NULL, 
NULL, NULL, 'MALE', NULL, NULL, NULL, NULL, 
NULL, NULL, NULL, NULL, NULL, '\0', '1', @currentTimeStamp, 
'0',NULL, NULL, NULL, NULL); 

SET @ItemsMaxPersonId=(SELECT MAX(id) FROM persons);

INSERT INTO `staffs` (`userId`, `personId`, `departmentId`, `subDepartmentId`, `designationId`, `whetherFaculty`, `whetherActivated`,
`facultyType`, `joiningDate`, `exitDate`, `yearsOfExperience`) VALUES (@ItemsMaxUserId, @ItemsMaxPersonId, NULL, NULL, NULL, TRUE, NULL, NULL, NULL, NULL, NULL); 


INSERT INTO `users` ( `code`, `firstName`, `middleName`, `lastName`, `shortName`, `printName`,
 `calendarId`, `whetherSystemUser`, `password`, `salt`, `ipAddress`, 
 `lockedOn`, `status`, `lockedStatus`, `lockedReason`, `noOfTimesLocked`, `noOfLoginFailed`, 
 `lastLockReleaseDate`, `totalAutoLogout`, `whetherDeleted`, `totalLoginFailed`, `accountingKey`,
  `userGroupId`, `whetherInternal`, `lastUpdatedBy`, `lastUpdate`, `version`, `whetherPasswordReset`, 
  `inactiveReasonCode`, `temporaryInActive`, `passwordLastUpdated`) VALUES 
('APPLICANT_PORTAL_USER', 'APP_FIRST_NAME', 'APP_MIDDLE_NAME', 'APP_LAST_NAME', 'APPLICANT PORTAL', 'APPLICANT PORTAL', 
'1', '\0', 'a8c4b282178bfa90b4bc73abfe110a1801e5f85f9ff33efb964ef1343b4211aa', ".,\'57;*PSF<K9KDV\'QY@*3EF9.95480", NULL, 
@currentTimeStamp, 1, 0, NULL, '0', '0', 
NULL, NULL, 0, 1, NULL, 
'2', 1, '1', @currentTimeStamp, '4', 0, 
NULL, 0, @currentTimeStamp);

SET @ItemsMaxUserId=(SELECT MAX(id) FROM users);

INSERT INTO `persons` ( `mobileNumber`, `mobileCountryCode`, `phoneNo`, `phoneCountryCode`, `phoneAreaCode`, `employeeId`, 
`firstName`, `middleName`, `emailId`, `lastName`, `shortName`, `birthDate`, 
`bloodGroup`, `bankDetailId`, `gender`,`maritalStatus`, `category`, `occupation`, `personalIncome`, 
`photoUrl`, `salutationId`, `castCategoryId`, `nationalityId`, `whetherEmployeeOfOrganization`, `whetherDeleted`, `lastUpdatedBy`, `lastUpdate`, 
`version`, `countryId`, `printName`,`religionId`, `physicalCharacteristicId`) 
VALUES ( NULL, NULL, NULL, NULL, NULL, NULL, 
'Applicant', NULL, NULL, 'Applicant', NULL, NULL, 
NULL, NULL, 'MALE', NULL, NULL, NULL, NULL, 
NULL, NULL, NULL, NULL, NULL, '\0', '1', @currentTimeStamp, 
'0',NULL, NULL, NULL, NULL); 

SET @ItemsMaxPersonId=(SELECT MAX(id) FROM persons);

INSERT INTO `staffs` (`userId`, `personId`, `departmentId`, `subDepartmentId`, `designationId`, `whetherFaculty`, `whetherActivated`,
`facultyType`, `joiningDate`, `exitDate`, `yearsOfExperience`) VALUES (@ItemsMaxUserId, @ItemsMaxPersonId, NULL, NULL, NULL, TRUE, NULL, NULL, NULL, NULL, NULL); 
