SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `survey_participant_info`;

CREATE TABLE `survey_participant_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `studentId` bigint(20) DEFAULT NULL,
  `applicantId` bigint(20) DEFAULT NULL,
  `enquiryId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  `surveyMasterId` bigint(20) DEFAULT NULL,
  `messageStatus` varchar(255) DEFAULT NULL,
  `surveyUrl` varchar(255) DEFAULT NULL,
  `userType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `FK3F64D07F45ECC5D0` (`surveyMasterId`),
  KEY `FK3F64D07FED259864` (`lastUpdatedBy`),
  KEY `FK3F64D07F591DC4A4` (`enquiryId`),
  KEY `FK3F64D07F89841194` (`studentId`),
  KEY `FK3F64D07F1946C89` (`userId`),
  KEY `FK3F64D07F5EFF0230` (`applicantId`),
  CONSTRAINT `FK3F64D07F1946C89` FOREIGN KEY (`userId`) REFERENCES `staffs` (`userId`),
  CONSTRAINT `FK3F64D07F45ECC5D0` FOREIGN KEY (`surveyMasterId`) REFERENCES `survey_master` (`id`),
  CONSTRAINT `FK3F64D07F591DC4A4` FOREIGN KEY (`enquiryId`) REFERENCES `enquiry` (`id`),
  CONSTRAINT `FK3F64D07F5EFF0230` FOREIGN KEY (`applicantId`) REFERENCES `application` (`id`),
  CONSTRAINT `FK3F64D07F89841194` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
  CONSTRAINT `FK3F64D07FED259864` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET FOREIGN_KEY_CHECKS=1;