CREATE TABLE `committee` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `committeeCode` varchar(255) NOT NULL,
  `committeeName` varchar(255) NOT NULL,
  `committeeCoordinator` bigint(20) NOT NULL,
  `validFromDate` date DEFAULT NULL,
  `validTillDate` date DEFAULT NULL,
  `status` bit(1) DEFAULT b'0',
  `description` text,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`,`committeeCoordinator`),
  KEY `fk_committee_coordinator_idx` (`committeeCoordinator`),
  KEY `fk_committee_lastUpdate_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_committee_coordinator` FOREIGN KEY (`committeeCoordinator`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_committee_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `committee_participant` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `committeeId` bigint(20) NOT NULL,
  `participantId` bigint(20) NOT NULL,
  `designation` varchar(55) DEFAULT NULL,
  `responsibility` varchar(255) DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `toDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index2` (`committeeId`),
  KEY `index3` (`participantId`),
  KEY `fk_committee_participant_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_committee_participant_1` FOREIGN KEY (`committeeId`) REFERENCES `committee` (`committeeCoordinator`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_committee_participant_2` FOREIGN KEY (`participantId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_committee_participant_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `committee_academy_location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `committeeId` bigint(20) NOT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   PRIMARY KEY (`id`),
  KEY `index2` (`academyLocationId`),
  KEY `index3` (`lastUpdatedBy`),
  KEY `index4` (`committeeId`),
  CONSTRAINT `fk_committee_academy_location_1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_committee_academy_location_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_committee_academy_location_3` FOREIGN KEY (`committeeId`) REFERENCES `committee` (`committeeCoordinator`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;