CREATE OR REPLACE
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `pnc_dashboard_top_and_bottom_attendance_student` AS
    select 
        `academy_location`.`academyName` AS `AcademyLocation`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `sections`.`id` AS `sectionId`,
        `users`.`code` AS `studentId`,
        `users`.`printName` AS `studentName`,
        `programs`.`programNameToBePrint` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `admission`.`code` AS `admissionNumber`,
        `student_attendance_dashboard_student_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_student_wise`.`admissionId` AS `admissionId`,
        sum(`student_attendance_dashboard_student_wise`.`presentRecords`) AS `presentReocrds`,
        sum(`student_attendance_dashboard_student_wise`.`absentRecords`) AS `absentReocrds`,
        sum(`student_attendance_dashboard_student_wise`.`totalRecords`) AS `totalReocrds`,
        round(((sum(`student_attendance_dashboard_student_wise`.`presentRecords`) / sum(`student_attendance_dashboard_student_wise`.`totalRecords`)) * 100),
                0) AS `presentPercentage`,
        round(((sum(`student_attendance_dashboard_student_wise`.`absentRecords`) / sum(`student_attendance_dashboard_student_wise`.`totalRecords`)) * 100),
                0) AS `absentPercentage`
    from
        (((((((`student_attendance_dashboard_student_wise`
        left join `admission` ON ((`student_attendance_dashboard_student_wise`.`admissionId` = `admission`.`id`)))
        left join `programs` ON ((`programs`.`id` = `admission`.`programId`)))
        left join `users` ON ((`admission`.`studentId` = `users`.`id`)))
        left join `batches` ON ((`admission`.`batchId` = `batches`.`id`)))
        left join `prog_batch_period_config` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        left join `sections` ON ((`sections`.`periodId` = `prog_batch_period_config`.`id`)))
        left join `academy_location` ON ((`student_attendance_dashboard_student_wise`.`academyLocationId` = `academy_location`.`id`)))
    group by `student_attendance_dashboard_student_wise`.`admissionId`
