CREATE TABLE `exam_event_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `eventId` bigint(20) NOT NULL,
  `evaluationTypeCourseId` bigint(20) NOT NULL,
  `eventName` varchar(255) DEFAULT NULL,
  `weightage` int DEFAULT 0,
  `minMarks` int DEFAULT NULL,
  `maxMarks` int DEFAULT NULL,
  `minGrade` varchar(45) DEFAULT NULL,
  `maxGrade` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_event_detail_unique_record` (`eventId`,`evaluationTypeCourseId`),
  KEY `exam_event_detail_eventId` (`eventId`),
  KEY `exam_event_detail_evaluationTypeCourseId` (`evaluationTypeCourseId`),
  KEY `exam_event_detail_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `exam_event_detail_eventId` FOREIGN KEY (`eventId`) REFERENCES `eval_seq_detail` (`id`),
  CONSTRAINT `exam_event_detail_evaluationTypeCourseId` FOREIGN KEY (`evaluationTypeCourseId`) REFERENCES `evaluation_type_course` (`id`),
  CONSTRAINT `exam_event_detail_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
