
CREATE TABLE `church_information` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `churchAffiliation` VARCHAR(255) NOT NULL,
  `localChurchName` VARCHAR(150) NOT NULL,
  `applicantPersonId` BIGINT(20) NULL DEFAULT NULL,
  `personId` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(45) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_applicantpersonId_idx` (`applicantPersonId` ASC),
  INDEX `fk_personId_idx` (`personId` ASC),
  INDEX `fk_userId_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_applicantpersonId`
    FOREIGN KEY (`applicantPersonId`)
    REFERENCES `applicant_person` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_personId`
    FOREIGN KEY (`personId`)
    REFERENCES `persons` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_userId`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT) DEFAULT CHARSET=UTF8;


CREATE TABLE `church_employment` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `position` VARCHAR(50) NULL DEFAULT NULL,
  `countryId` BIGINT(20) NULL DEFAULT NULL,
  `churchInformationId` INT(11) NOT NULL,
  `fromDate` DATE NULL DEFAULT NULL,
  `toDate` DATE NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_countryId_idx` (`countryId` ASC),
  INDEX `fk_churchEmpId_idx` (`churchInformationId` ASC),
  INDEX `fk_userId_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_countryId_idx`
    FOREIGN KEY (`countryId`)
    REFERENCES `country` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_churchEmpId_idx`
    FOREIGN KEY (`churchInformationId`)
    REFERENCES `church_information` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_userId_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT)
 DEFAULT CHARSET=UTF8;

