
set sql_safe_updates = 0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_ATTENDANCE_MISSED_BY_FACULTY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT \n    T1.id AS ID,\n DATE_FORMAT(T1.sessionDate, \'%d-%m-%Y\') AS SESSION_DATE,\n    T2.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,\n    T3.displayName AS ACADEMY_NAME,\n    T5.firstName AS FIRST_NAME,\n    T5.lastName AS LAST_NAME,\n	T5.emailId AS EMAIL_ID,\n    T5.mobileNumber AS MOBILE_NO,\n    T5.mobileCountryCode AS MOBILE_CODE,\n    DATE_FORMAT(T1.slotFrom, \'%h:%i %p\') AS SLOT_FROM,\n    DATE_FORMAT(T1.slotTo, \'%h:%i %p\') AS SLOT_TO\nFROM\n    course_coverage_plan T1\n        LEFT JOIN\n    course_variants T2 ON T2.id = T1.courseVariantId\n        LEFT JOIN\n    academy_location T3 ON T3.id = T1.academyLocationId\n        LEFT JOIN\n    staffs T4 ON T4.userId = T1.facultyId\n        LEFT JOIN\n    persons T5 ON T5.id = T4.personId\nWHERE\n    T1.id IN (namedParams)' WHERE `dataProviderId`=@dtproviderId;
set sql_safe_updates = 1;