DROP procedure IF EXISTS `rpt_Admission_Summary`;

DELIMITER $$
CREATE PROCEDURE `rpt_Admission_Summary`(academyLocation text, intakeYear int(10), StartDate date, EndDate date, ProgramCategory varchar(5), ProgramGroup  varchar(5))
BEGIN

   declare StartDateNull, EndDateNull, ProgramCategoryNull, ProgramGroupNull boolean;

   SET SQL_SAFE_UPDATES = 0;
   
   call str_to_row (academyLocation);
   
   if StartDate is null then
  	set StartDateNull = 1;
   else set StartDateNull = 0;
   end if;
   if EndDate is null then
  	set EndDateNull = 1;
   else set EndDateNull = 0;
   end if;
   if ProgramCategory is null then
  	set ProgramCategoryNull = 1;
   else set ProgramCategoryNull = 0;
   end if;
   if ProgramGroup is null then
  	set ProgramGroupNull = 1;
   else set ProgramGroupNull = 0;
   end if;

   drop table if exists tbl_rpt_Admission_Summary;
   create table tbl_rpt_Admission_Summary(Brand_Campus text, Brand_Campus_ID long, programId long, grade varchar(50)
   , Total_Admission int default 0, Weekly_movement_Admission int default 0, conversion_perc_assessment double default 0
   , Target_for_admission int default 0 , Perc_Target_Admission double default 0
   , YOY_Variance_for_total_Admissions_target double default 0,prev_yr_tot_admission int default 0, totalSuccessfulApplications int default 0)
   comment 'Temporary Table for Admission Summary Report';

   insert into tbl_rpt_Admission_Summary(Brand_Campus, Brand_Campus_ID, programId, grade)
   select concat(al.academyName, '-', al.locationName), al.id, p.id, p.programNameToBePrint
  	from academy_location al join programs p on al.id = p.academyLocationId and p.status = 'O'
  	join batches as b on p.id = b.programId
  	where p.programClosureDate is null
		and al.id in (select s from tbl_str_to_row) and b.intakeYearId = intakeYear
  	and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  	and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
  	group by al.id, p.id;

	update tbl_rpt_Admission_Summary as t, (select count(distinct a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, a.admissionDate, b.startDate, b.tillDate
  	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId
  	where a.academyLocationId in (select s from tbl_str_to_row) 
  		and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
 		and	(date(a.admissionDate)<= EndDate or 1 = EndDateNull)
  	group by a.academyLocationId, p.id) as q
  	set t.Total_Admission = q.tot_admissions
  	where t.Brand_Campus_ID = q.academyLocationId and t.programId = q.grade_id;



   update tbl_rpt_Admission_Summary as t, 
(select a.academyLocationId, a.programId, count(distinct a.id) as tot_weekly_admissions, calendars.weekStart

from admission as a join academy_location_purpose alp on a.academyLocationId = alp.academyLocationId
join calendars on alp.calendarId = calendars.id 
join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches as b on a.batchId = b.id and b.intakeYearId = intakeYear
join programs as p on p.id = b.programId
where date(a.admissionDate) between (date_sub(current_date(), interval WEEKDAY(current_date()) - (case when weekStart = 'MONDAY' then 0
	when weekStart = 'TUESDAY' then 1 when weekStart = 'WEDNESDAY' then 2
	when weekStart = 'THURSDAY' then 3 when weekStart = 'FRIDAY' then 4
	when weekStart = 'SATURDAY' then 5 end) day)) and current_date()
and a.academyLocationId in (select s from tbl_str_to_row)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
and	(date(a.admissionDate)<= EndDate or 1 = EndDateNull)
group by a.academyLocationId, p.id) as q
set t.Weekly_movement_Admission = q.tot_weekly_admissions
where t.Brand_Campus_ID = q.academyLocationId and t.programId = q.programId;

update tbl_rpt_Admission_Summary as t, (select adm.tot_admissions, adm.batchId, adm.grade_id, adm.academyLocationId, apl.Total_SUCCESSFUL_Admission as totalSuccessfulApplications
   , (adm.tot_admissions / ifnull(apl.Total_SUCCESSFUL_Admission, 1) * 100) as conv_perc
   from
   (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, a.admissionDate, b.startDate, b.tillDate
	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId
  	where a.academyLocationId in (select s from tbl_str_to_row)
			and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
			and	(date(a.admissionDate)<= EndDate or 1 = EndDateNull)
  			and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  			and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
  			 group by a.academyLocationId, p.id) as adm join
  	(Select al.id, p.id as grade_id, count(distinct a.id) as Total_SUCCESSFUL_Admission
  		from application a right join application_program ap on a.id=ap.applicationId
  		left join programs p on p.id = ap.programId
  		left join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
  		where a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN')
  		and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
 		and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
		 group by al.id, p.id) apl
  	on adm.academyLocationId = apl.id and adm.grade_id = apl.grade_id) as d
  	set t.conversion_perc_assessment = d.conv_perc
    , t.totalSuccessfulApplications = d.totalSuccessfulApplications
  	where t.Brand_Campus_ID = d.academyLocationId and t.programId = d.grade_id;


	update tbl_rpt_Admission_Summary as t, (
	select p.academyLocationId, b.intakeYearId, p.id programId, b.id batchId, (b.seatCapacity - count(distinct a.Id)) as target_for_admission
	   	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId
  	where a.academyLocationId in (select s from tbl_str_to_row)
		and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
		and	(date(a.admissionDate)<= EndDate or 1 = EndDateNull)
		and a.status in ('ADMISSION_CONFIRMED', 'ADMITTED_PROVISIONALLY')
	group by p.id, b.id) as q
	   set t.Target_for_admission = q.target_for_admission
	   where t.Brand_Campus_ID = q.academyLocationId and t.programId = q.programId;

   
   update tbl_rpt_Admission_Summary as t
   set t.Perc_Target_Admission = ifnull(t.Total_Admission / Target_for_admission * 100,0);

   
   update tbl_rpt_Admission_Summary as t,
   (select curr_yr_admission.tot_admissions as cur_tot_admissions, curr_yr_admission.batchId, curr_yr_admission.grade_id, curr_yr_admission.academyLocationId, prev_yr_admission.tot_admissions as prev_tot_admissions
   , ifnull(((curr_yr_admission.tot_admissions - prev_yr_admission.tot_admissions)/prev_yr_admission.tot_admissions * 100),0) as YOY_Variance_for_total_Admissions_target
   from
   (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, a.admissionDate
	   	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = (select id from intake_year 
	where itemValue = (select itemValue - 1 from intake_year where id = intakeYear))
		join programs p on p.id = b.programId
  	where a.academyLocationId in (select s from tbl_str_to_row)
		and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
		and	(date(a.admissionDate)<= EndDate or 1 = EndDateNull)
  		group by a.academyLocationId, p.id) as prev_yr_admission
   join (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, a.admissionDate
 	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId
  	where a.academyLocationId in (select s from tbl_str_to_row)
  
   
  		and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
		and	(date(a.admissionDate)<= EndDate or 1 = EndDateNull)
  		group by a.academyLocationId, p.id) as curr_yr_admission
   on prev_yr_admission.academyLocationId = curr_yr_admission.academyLocationId
   and prev_yr_admission.grade_id = curr_yr_admission.grade_id) as d
   set t.YOY_Variance_for_total_Admissions_target = d.YOY_Variance_for_total_Admissions_target
    ,t.prev_yr_tot_admission=d.prev_tot_admissions
   where t.Brand_Campus_ID = d.academyLocationId and t.programId = d.grade_id;

   
   select Brand_Campus_ID as academyLocationId, Brand_Campus as academyLocationName
  	, programId, grade as programName, Total_Admission as totalAdmission
  	, Weekly_movement_Admission as WMofAdmission, conversion_perc_assessment as ConPercFromAs
  	, Target_for_admission as targetForAdmission, Perc_Target_Admission as perOfTargetForAdmission
  	, YOY_Variance_for_total_Admissions_target as yoyTotalAdmission, prev_yr_tot_admission as prevTotalAdmission, totalSuccessfulApplications
   from tbl_rpt_Admission_Summary order by Brand_Campus;

END$$

DELIMITER ;

