ALTER TABLE `course_components` 
ADD COLUMN `weighting` INT(11) NOT NULL DEFAULT 100 AFTER `componentStatus`;
ALTER TABLE `courses` 
ADD COLUMN `calculationRule` VARCHAR(45) NULL DEFAULT NULL AFTER `considerInPromotion`;

ALTER TABLE `marksheet` 
ADD COLUMN `parentCourseId` BIGINT(20) NULL DEFAULT NULL AFTER `planPrintName`,
ADD COLUMN `parentCourseGradePoint` DOUBLE NULL DEFAULT NULL AFTER `parentCourseId`,
ADD COLUMN `parentCourseGrade` VARCHAR(45) NULL DEFAULT NULL AFTER `parentCourseGradePoint`,
ADD COLUMN `parentCourseEffectiveMarks` DOUBLE NULL DEFAULT NULL AFTER `parentCourseGrade`,
ADD COLUMN `parentCourseMaxMarksOrGrade` VARCHAR(45) NULL DEFAULT NULL AFTER `parentCourseEffectiveMarks`,
ADD COLUMN `parentCourseStatus` VARCHAR(45) NULL DEFAULT NULL AFTER `parentCourseMaxMarksOrGrade`,
ADD INDEX `fk_marksheet_parentCourseId_idx_idx` (`parentCourseId` ASC);
ALTER TABLE `marksheet` 
ADD CONSTRAINT `fk_marksheet_parentCourseId_idx`
  FOREIGN KEY (`parentCourseId`)
  REFERENCES `courses` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

ALTER TABLE `evaluation_plan_rank` 
ADD COLUMN `parentCourseId` BIGINT(20) NULL DEFAULT NULL AFTER `revisedStatus`,
ADD COLUMN `parentCourseMaxMarksFrom` DOUBLE NULL DEFAULT NULL AFTER `parentCourseId`,
ADD COLUMN `parentCourseMaxGradeFrom` VARCHAR(45) NULL DEFAULT NULL AFTER `parentCourseMaxMarksFrom`,
ADD COLUMN `parentCourseGradePoint` DOUBLE NULL DEFAULT NULL AFTER `parentCourseMaxGradeFrom`,
ADD COLUMN `parentCourseGrade` VARCHAR(45) NULL DEFAULT NULL AFTER `parentCourseGradePoint`,
ADD COLUMN `parentCourseObtainedMarks` DOUBLE NULL DEFAULT NULL AFTER `parentCourseGrade`,
ADD COLUMN `parentCourseEffectiveMarks` DOUBLE NULL DEFAULT NULL AFTER `parentCourseObtainedMarks`,
ADD COLUMN `parentCourseStatus` VARCHAR(45) NULL DEFAULT NULL AFTER `parentCourseEffectiveMarks`,
ADD INDEX `fk_evaluation_plan_rank_parentCourseId_idx_idx` (`parentCourseId` ASC);
ALTER TABLE `evaluation_plan_rank` 
ADD CONSTRAINT `fk_evaluation_plan_rank_parentCourseId_idx`
  FOREIGN KEY (`parentCourseId`)
  REFERENCES `courses` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;


set sql_safe_updates=0;
update courses as c, courses as c1
set c.calculationRule='AVERAGE' 
where c.id = c1.parentCourseId and c1.parentCourseId is not null and c.calculationRule is null;
set sql_safe_updates=1;