CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    SQL SECURITY DEFINER
VIEW `mark_entry_report` AS
    SELECT 
        `examination_result_history`.`id` AS `examResultHistoryId`,
        `users`.`id` AS `userId`,
        `academy_location`.`id` AS `academyLocationId`,
        `sections`.`id` AS `sectionId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `batches`.`id` AS `batchId`,
        `programs`.`id` AS `programId`,
        `eval_seq_detail`.`id` AS `eventId`,
        `evaluation_plan`.`id` AS `evaluationPlanId`,
        `course_variants`.`id` AS `courseVariantId`,
        `courses`.`id` AS `courseId`,
        `examination_result_history`.`admissionId` AS `admissionId`,
        `users`.`printName` AS `userName`,
        `user_groups`.`userGroupName` AS `userGroupName`,
        `users`.`status` AS `userStatus`,
        `examination_result_history`.`lastUpdate` AS `markEntryTime`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`programPeriodName` AS `periodName`,
        `sections`.`sectionCode` AS `sectionName`,
        `course_variants`.`courseVariantCode` AS `courseVariantName`,
        `courses`.`courseName` AS `courseName`,
        `studentUser`.`printName` AS `studentName`,
        `studentUser`.`code` AS `studentCode`,
        `studentUser`.`id` AS `studentUserId`,
        `admission`.`code` AS `admissionCode`,
        (CASE
            WHEN (`evaluation_plan`.`whetherDynamicScheme`=true) THEN `exam_event_detail`.`eventName`
            ELSE `eval_seq_detail`.`detailSequenceNumber`
        END) AS `eventName`,
        
        `evaluation_plan`.`evaluationPlanNumber` AS `planName`,
          `evaluation_plan_level_one`.`levelName` AS `typeName`,
            `evaluation_plan_level_two`.`levelName` AS `subTypeName`,
           `evaluation_sequence`.`printNameInMarksheet` AS `methodName`,
        (CASE
            WHEN (`eval_seq_detail`.`evalInMarksOrGrade` LIKE 'MARK') THEN `examination_result_history`.`effectiveMarks`
            ELSE `examination_result_history`.`finalGrade`
        END) AS `finalMarks`,
        `examination_result_history`.`status` AS `resultStatus`,
        `users`.`whetherInternal` AS `userType`,
        `users`.`code` AS `userCode`,
        `academy_location`.`displayName` AS `academyLocationName`,
        `students`.`personId` AS `personId`,
        `admission`.`programBatchSeatConfigId` AS `seatConfigId`
    FROM
        (((((((((((((((((`examination_result_history`
        LEFT JOIN `users` ON ((`examination_result_history`.`lastUpdatedBy` = `users`.`id`)))
        LEFT JOIN `admission` ON ((`examination_result_history`.`admissionId` = `admission`.`id`)))
        LEFT JOIN `user_groups` ON ((`users`.`userGroupId` = `user_groups`.`id`)))
        LEFT JOIN `sections` ON ((`examination_result_history`.`sectionId` = `sections`.`id`)))
        LEFT JOIN `prog_batch_period_config` ON ((`sections`.`periodId` = `prog_batch_period_config`.`id`)))
        LEFT JOIN `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        LEFT JOIN `course_variants` ON ((`examination_result_history`.`courseVariantId` = `course_variants`.`id`)))
        LEFT JOIN `courses` ON ((`course_variants`.`courseId` = `courses`.`id`)))
        LEFT JOIN `academy_location` ON (((`programs`.`academyLocationId` = `academy_location`.`id`)
            AND (`admission`.`academyLocationId` = `academy_location`.`id`))))
        LEFT JOIN `eval_seq_detail` ON ((`examination_result_history`.`evaluationDetailSequenceId` = `eval_seq_detail`.`id`)))
        LEFT JOIN `exam_event_detail` ON ((`eval_seq_detail`.`id` = `exam_event_detail`.`eventId`)))
       LEFT  JOIN `evaluation_type_course`  ON ((`exam_event_detail`.`evaluationTypeCourseId` = `evaluation_type_course`.`id`
      AND   (`evaluation_type_course`.`courseVariantId`= `examination_result_history`.`courseVariantId`)
	    AND (`evaluation_type_course`.`periodId`=`examination_result_history`.`periodId`)
       ))
	    
        LEFT JOIN `evaluation_sequence` ON ((`eval_seq_detail`.`evalSequenceId` = `evaluation_sequence`.`id`)))
        LEFT JOIN `evaluation_plan_level_two` ON ((`evaluation_sequence`.`evalPlanLevelTwoId` = `evaluation_plan_level_two`.`id`)))
        LEFT JOIN `evaluation_plan_level_one` ON ((`evaluation_plan_level_two`.`evalPlanLevelOneId` = `evaluation_plan_level_one`.`id`)))
        LEFT JOIN `evaluation_plan` ON ((`evaluation_plan_level_one`.`evaluationPlanId` = `evaluation_plan`.`id`)))
        LEFT JOIN `students` ON ((`admission`.`studentId` = `students`.`userId`)))
        LEFT JOIN `users` `studentUser` ON ((`students`.`userId` = `studentUser`.`id`));
