CREATE TABLE `sponsor_academy_location` (
  `id` BIGINT(20) NOT NULL,
  `sponsorId` BIGINT(20) NOT NULL,
  `academyLocationId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_sponsor_academy_location_to_sponsor1234_idx` (`sponsorId` ASC),
  INDEX `fk_sponsor_academy_location_to_acadLocation1234_idx` (`academyLocationId` ASC),
  INDEX `fk_sponsor_academy_location_to_user123_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_sponsor_academy_location_to_sponsor1234`
    FOREIGN KEY (`sponsorId`)
    REFERENCES `sponsors` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_sponsor_academy_location_to_acadLocation1234`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_sponsor_academy_location_to_user123`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);