
DELIMITER //
DROP TRIGGER IF EXISTS `fee_payer_detail_AFTER_UPDATE` //
DELIMITER ;

DELIMITER //
DROP TRIGGER IF EXISTS `fee_payer_detail_AFTER_INSERT` //
DELIMITER ;

DELIMITER //
CREATE TRIGGER fee_payer_detail_AFTER_UPDATE 
   After UPDATE ON fee_payer_detail 
   FOR EACH ROW 
BEGIN
	IF OLD.payerType = 'PERSON' THEN
		IF NEW.id = OLD.id and (NEW.emailHome<> OLD.emailHome or NEW.mobileNumber <> OLD.mobileNumber or NEW.countryCode <> OLD.countryCode or NEW.emailHomeUseForCommunication <> OLD.emailHomeUseForCommunication)
		THEN
			IF New.emailHomeUseForCommunication is not null && New.emailHomeUseForCommunication != 0 then
			    IF New.applicantPersonId is null then 
					INSERT INTO person_contact_history(personId,emailId,mobileNumber,mobileCountryCode,feePayerId)
				     VALUES(New.personId,New.emailHome,New.mobileNumber,New.countryCode,New.id);
			    ELSE
				    INSERT INTO applicant_person_contact_history(applicantPersonId,emailId,mobileNumber,mobileCountryCode,feePayerId)
				     VALUES(New.applicantPersonId,New.emailHome,New.mobileNumber,New.countryCode,New.id);
			    END IF;
		    END IF;
	    END IF;

	    IF NEW.id = OLD.id and (NEW.emailWork<> OLD.emailWork or NEW.workTelephone <> OLD.workTelephone or NEW.workTelephoneCountryCode <> OLD.workTelephoneCountryCode or NEW.emailWorkUseForCommunication <> OLD.emailWorkUseForCommunication)
		THEN
			IF New.emailWorkUseForCommunication is not null && New.emailWorkUseForCommunication != 0 then
			    IF New.applicantPersonId is null then 
					INSERT INTO person_contact_history(personId,emailId,mobileNumber,mobileCountryCode,feePayerId)
				     VALUES(New.personId,New.emailWork,New.workTelephone,New.workTelephoneCountryCode,New.id);
			    ELSE
				    INSERT INTO applicant_person_contact_history(applicantPersonId,emailId,mobileNumber,mobileCountryCode,feePayerId)
				     VALUES(New.applicantPersonId,New.emailWork,New.workTelephone,New.workTelephoneCountryCode,New.id);
			    END IF;
		    END IF;
	    END IF;
	ELSE
		IF NEW.id = OLD.id and (NEW.emailWork<> OLD.emailWork or NEW.workTelephone <> OLD.workTelephone or NEW.workTelephoneCountryCode <> OLD.workTelephoneCountryCode)
		THEN
			IF New.applicantPersonId is null then 
				INSERT INTO person_contact_history(personId,emailId,mobileNumber,mobileCountryCode,feePayerId)
			     VALUES(New.personId,New.emailWork,New.workTelephone,New.workTelephoneCountryCode,New.id);
		    ELSE
			    INSERT INTO applicant_person_contact_history(applicantPersonId,emailId,mobileNumber,mobileCountryCode,feePayerId)
			     VALUES(New.applicantPersonId,New.emailWork,New.workTelephone,New.workTelephoneCountryCode,New.id);
		    END IF;
		END IF;	    
	END IF;
END; //
 
DELIMITER ;

DELIMITER //
CREATE TRIGGER fee_payer_detail_AFTER_INSERT 
   After INSERT ON fee_payer_detail 
   FOR EACH ROW 
BEGIN
    IF New.payerType = 'PERSON' THEN
		IF New.emailHomeUseForCommunication is not null && New.emailHomeUseForCommunication != 0 then
			IF New.applicantPersonId is null then 
				INSERT INTO person_contact_history(personId,emailId,mobileNumber,mobileCountryCode,feePayerId)
			     VALUES(New.personId,New.emailHome,New.mobileNumber,New.countryCode,New.id);
		    ELSE
			    INSERT INTO applicant_person_contact_history(applicantPersonId,emailId,mobileNumber,mobileCountryCode,feePayerId)
			     VALUES(New.applicantPersonId,New.emailHome,New.mobileNumber,New.countryCode,New.id);
		    END IF;
	    END IF;

	    IF New.emailWorkUseForCommunication is not null && New.emailWorkUseForCommunication != 0 then
			IF New.applicantPersonId is null then 
				INSERT INTO person_contact_history(personId,emailId,mobileNumber,mobileCountryCode,feePayerId)
			     VALUES(New.personId,New.emailWork,New.workTelephone,New.workTelephoneCountryCode,New.id);
		    ELSE
			    INSERT INTO applicant_person_contact_history(applicantPersonId,emailId,mobileNumber,mobileCountryCode,feePayerId)
			     VALUES(New.applicantPersonId,New.emailWork,New.workTelephone,New.workTelephoneCountryCode,New.id);
		    END IF;
	    END IF;
    ELSE
    	IF New.applicantPersonId is null then 
			INSERT INTO person_contact_history(personId,emailId,mobileNumber,mobileCountryCode,feePayerId)
		     VALUES(New.personId,New.emailWork,New.workTelephone,New.workTelephoneCountryCode,New.id);
	    ELSE
		    INSERT INTO applicant_person_contact_history(applicantPersonId,emailId,mobileNumber,mobileCountryCode,feePayerId)
		     VALUES(New.applicantPersonId,New.emailWork,New.workTelephone,New.workTelephoneCountryCode,New.id);
	    END IF;
    END IF;
END; //

DELIMITER ; 