CREATE TABLE `student_favourite_course_mapping` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `parameterizedId` BIGINT(20) NOT NULL,
  `admissionId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_student_favourite_course_mapping_1_idx` (`parameterizedId` ASC),
  INDEX `fk_admission_idx` (`admissionId` ASC),
  CONSTRAINT `fk_param`
    FOREIGN KEY (`parameterizedId`)
    REFERENCES `program_batch_course_param` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_admission`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT
);