-- --------------------------------------------------------------------------------
-- Routine DDL
-- Note: comments before and after the routine body will not be stored by the server
-- --------------------------------------------------------------------------------
DROP procedure IF EXISTS `childLateFeeConfig`;
DELIMITER $$

CREATE PROCEDURE `childLateFeeConfig`()
BEGIN
    DECLARE vchildHeadConfigId, vid, vfeePlanRuleStageId, vlateFeeHeadId, vlastUpdatedBy BIGINT(20);
    DECLARE visActive boolean;
    DECLARE vwhetherProrataBilling,vwhetherRefundAvailable,vwhetherInstallPostDated BIT;
    declare vamountType, vlateFeeType, vlateFeePeriodicity, vruleApplicable VARCHAR(255);
    declare vlateFeeAmount, vlateFeePercentage, vfeeAmount ,vmaximumLateFeeAmount DOUBLE;
	declare result_no_more_rows boolean default false;

START TRANSACTION;
 BLOCK1: begin
DECLARE detailData CURSOR FOR
select childHeadConfig.id,headConfig.id,headConfig.feePlanRuleStageId,headConfig.lateFeeHeadId,headConfig.lateFeeType,headConfig.lateFeePeriodicity,headConfig.lateFeeAmount,headConfig.maximumLateFeeAmount,headConfig.lateFeePercentage,headConfig.ruleApplicable,headConfig.amountType,headConfig.isActive,headConfig.lastUpdatedBy,headConfig.whetherProrataBilling,headConfig.whetherRefundAvailable,headConfig.whetherInstallPostDated,headConfig.feeAmount from fee_stage_head_config headConfig
left join bill_fee_plan_rule_stage ruleStage on headConfig.id=ruleStage.feeStageHeadConfigId
left join bill_header header on header.id=ruleStage.billId
left join fee_stage_head_config childHeadConfig on childHeadConfig.parentFeeHeadId=headConfig.id and childHeadConfig.lateFeeType is not null
where (header.raiseBillType='LATE_FEE' and header.billStatus <> 'CANCELLED') or (header.id is null and headConfig.whetherLateFee = true) group by headConfig.id;
declare continue handler for not found  set result_no_more_rows := true;
 set sql_safe_updates=0;
	OPEN detailData;
		detailData: LOOP
		fetch detailData into vchildHeadConfigId, vid, vfeePlanRuleStageId, vlateFeeHeadId, vlateFeeType, vlateFeePeriodicity, vlateFeeAmount,vmaximumLateFeeAmount, vlateFeePercentage, vruleApplicable, vamountType, visActive, vlastUpdatedBy, vwhetherProrataBilling, vwhetherRefundAvailable, vwhetherInstallPostDated, vfeeAmount;
        if result_no_more_rows then set result_no_more_rows := false;
         close detailData;
        leave detailData;
	end if;
    if(vchildHeadConfigId is null)
    then
		if(vlateFeeHeadId is not null) then
			INSERT INTO`fee_stage_head_config`(`feePlanRuleStageId`, `feeHeadId`,`lateFeeType`,`lateFeePeriodicity`,`lateFeeAmount`,`maximumLateFeeAmount`,`lateFeePercentage`,`ruleApplicable`,`amountType`,`parentFeeHeadId`,`isActive`,`lastUpdatedBy`, `whetherProrataBilling`,`whetherRefundAvailable`,`whetherInstallPostDated`,`feeAmount`) values (vfeePlanRuleStageId, vlateFeeHeadId, vlateFeeType, vlateFeePeriodicity, vlateFeeAmount,vmaximumLateFeeAmount, vlateFeePercentage, vruleApplicable, vamountType, vid, visActive, vlastUpdatedBy, vwhetherProrataBilling, vwhetherRefundAvailable, vwhetherInstallPostDated, 0.00);
		else
			if(select count(id) from fee_heads where feeHeadName='Late Fee' limit 1)=0 then
				INSERT INTO `fee_heads`(`feeHeadName`, `feeHeadStatus`, `whetherLateFeeHead`, `whetherDiscountFeeHead`, `whetherNormalFeeHead`, `whetherDependentFeeHead`, `lastUpdatedBy`)VALUES('Late Fee',true,true,false,true,false,1);
            end if;
			INSERT INTO`fee_stage_head_config`(`feePlanRuleStageId`, `feeHeadId`,`lateFeeType`,`lateFeePeriodicity`,`lateFeeAmount`,`maximumLateFeeAmount`,`lateFeePercentage`,`ruleApplicable`,`amountType`,`parentFeeHeadId`,`isActive`,`lastUpdatedBy`, `whetherProrataBilling`,`whetherRefundAvailable`,`whetherInstallPostDated`,`feeAmount`) values (vfeePlanRuleStageId, (select id from fee_heads where feeHeadName='Late Fee' limit 1), vlateFeeType, vlateFeePeriodicity, vlateFeeAmount,vmaximumLateFeeAmount, vlateFeePercentage, vruleApplicable, vamountType, vid, visActive, vlastUpdatedBy, vwhetherProrataBilling, vwhetherRefundAvailable, vwhetherInstallPostDated, 0.00);
        end if;        
    end if;
   
update bill_fee_plan_rule_stage bfprs
        inner join
    bill_header bh ON bh.id = bfprs.billId
        and bh.raiseBillType = 'LATE_FEE' and bh.billStatus<>'CANCELLED'
        inner join
    fee_stage_head_config fshcParent ON fshcParent.id = bfprs.feeStageHeadConfigId
        inner join
    fee_stage_head_config fshcChild ON fshcChild.parentFeeHeadId = fshcParent.id
        and fshcChild.lateFeeType is not null 
set 
    bfprs.feeStageHeadConfigId = fshcChild.id;
    

END LOOP detailData;   


END BLOCK1;
BEGIN

	DECLARE done INTEGER DEFAULT 0;
	declare varid,vfeePlanRuleStageId, varlateFeeHeadId, varfeeHeadId, varlateFeeType, varlateFeePeriodicity, varlateFeeAmount, varlateFeePercentage, varmaximumLateFeeAmount, varruleApplicable, varamountType, varparentFeeHeadId, varlastUpdate, varlastUpdatedBy varchar(255);
	declare varisActive, varwhetherRefundAvailable boolean;
	declare varfhid, varbillfhid int;
				
	DEClARE cursor_fh1 CURSOR FOR select fshc.id,fshc.feePlanRuleStageId, fshc.lateFeeHeadId
, fshc.feeHeadId, fshc.lateFeeType, fshc.lateFeePeriodicity, fshc.lateFeeAmount
, fshc.lateFeePercentage, fshc.maximumLateFeeAmount, fshc.ruleApplicable, fshc.amountType
, fshc.parentFeeHeadId, fshc.isActive, fshc.lastUpdate, fshc.lastUpdatedBy
, fshc.whetherRefundAvailable from fee_stage_head_config as fshc
where fshc.whetherLateFee = true and fshc.parentFeeHeadId is null and fshc.isActive=true and fshc.id  not IN  (select parentFeeHeadId from fee_stage_head_config as fshcc
where fshcc.isActive = true and fshcc.lateFeeType is not null AND fshcc.parentFeeHeadId is not null);
	
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = 1;

	OPEN cursor_fh1;
	proc_fh1: LOOP
		FETCH cursor_fh1 INTO varid,vfeePlanRuleStageId, varlateFeeHeadId, varfeeHeadId, varlateFeeType, varlateFeePeriodicity, varlateFeeAmount, varlateFeePercentage, varmaximumLateFeeAmount, varruleApplicable, varamountType, varparentFeeHeadId, varisActive, varlastUpdate, varlastUpdatedBy, varwhetherRefundAvailable;

	IF done = 1 THEN 
		LEAVE proc_fh1;
	END IF;

		INSERT INTO fee_stage_head_config(feePlanRuleStageId,feeHeadId, lateFeeType,lateFeePeriodicity, lateFeeAmount, lateFeePercentage, maximumLateFeeAmount, ruleApplicable, amountType, parentFeeHeadId, isActive, lastUpdate, lastUpdatedBy, feeAmount, whetherInstallPostDated, whetherRefundAvailable, whetherProrataBilling) 
	values (vfeePlanRuleStageId,varlateFeeHeadId, varlateFeeType, varlateFeePeriodicity, varlateFeeAmount, varlateFeePercentage, varmaximumLateFeeAmount, varruleApplicable, varamountType, varid, true, now(), 1, 0.0, 0, varwhetherRefundAvailable, false);

END LOOP proc_fh1;

CLOSE cursor_fh1;
end;
update fee_stage_head_config fshc set lateFeeType=null,lateFeePeriodicity = null,lateFeeAmount=null,lateFeePercentage=null,maximumLateFeeAmount=null,ruleApplicable=null,lateFeeHeadId=null where whetherLateFee=1 and parentFeeHeadId is null;
 set sql_safe_updates=1;
COMMIT;    
END