set sql_safe_updates=0;
SET @dataproviderId2=(SELECT id FROM dydt_data_provider WHERE `providerName`='Student Admission Program Data Provider');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,
 pd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,
 psd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,
 b.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate,
 ay.itemValue AS intake_year ,a.code AS admission_code ,a.studentId as student_id,
 pbpc.programPeriodName AS period_name ,pbpc.printName AS period_print_name ,prsn.photoUrl AS img_photo_url ,date_format(DATE(NOW()), "%d-%m-%Y") as today_date,
 u.code AS person_code ,prsn.firstName AS first_name ,prsn.bloodGroup as blood_group,prsn.middleName AS middle_name,prsn.lastName AS last_name ,CONCAT(UCASE(LEFT(gender, 1)),LCASE(SUBSTRING(gender, 2))) as student_gender,cc.itemValue AS cast_category ,date_format(DATE(prsn.birthDate),"%d-%m-%Y") AS birth_date,ntn.itemValue as nationality,rel.itemValue as religions,sec.sectionCode as section_code,
 TRUNCATE(DATEDIFF(date_format(DATE(NOW()), "%Y-%m-%d"),prsn.birthDate) / 365.25,0) as student_age
 FROM program_batch_students pbs 
 LEFT JOIN admission a ON a.id = pbs.admissionId
 LEFT JOIN batches b   ON b.id = pbs.programBatchId
 LEFT JOIN programs p ON b.programId = p.id
 LEFT JOIN intake_year ay ON ay.id = b.intakeYearId
 LEFT JOIN department pd ON pd.id = p.programDepartmentId
 LEFT JOIN department psd ON psd.id = p.subDepartmentId
 LEFT JOIN prog_batch_period_config pbpc ON pbpc.programBatchId = b.id
 LEFT JOIN students st ON st.userId = a.studentId
 LEFT JOIN persons prsn ON prsn.id = st.personId
 LEFT JOIN users u ON u.id = st.userId
 LEFT JOIN caste_categories cc ON cc.id = prsn.castCategoryId
 LEFT JOIN nationalities ntn on ntn.id = prsn.nationalityId
 LEFT JOIN religions rel on rel.id = prsn.religionId
 LEFT JOIN sections sec on sec.id = pbs.sectionId',
    `resultColumnsDef` = 'program_code,program_name,program_print_name, primary_dept_code,cast_category,birth_date,primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate,intake_year,section_code,admission_code,student_id,last_name,first_name,middle_name,person_code,img_photo_url,period_name,period_print_name,nationality,religions,today_date,student_age,student_gender,blood_group',
    `sqlWhereQueryDef` = 'WHERE a.id = PRM_ADMISSION_ID AND pbs.isCurrentPeriod = true AND pbs.isCurrentSection = true AND pbs.exitDate is null'
WHERE
    `dataSourceCode` = 'STUDENT_ADMISSION_PROGRAM_INFO' AND dataProviderId = @dataproviderId2;

-- Father DT Provider Update
SET @dataproviderId1=(SELECT id FROM dydt_data_provider WHERE `providerName`='Student Father Info');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT per_father.firstName AS father_first_name,per_father.lastName AS father_last_name, per_father.mobileCountryCode as father_mobile_country_code,per_father.mobileNumber as father_mobile_no
FROM students st
INNER JOIN persons per ON st.personId = per.id
INNER JOIN person_relationships per_rel ON per.id = per_rel.personId AND per_rel.relationship = "FATHER"
INNER JOIN persons per_father ON per_rel.relatedPersonId = per_father.id',
    `resultColumnsDef` = 'father_first_name,father_last_name,father_mobile_country_code,father_mobile_no'
WHERE
    `dataSourceCode` = 'Student Fathers Info' AND dataProviderId = @dataproviderId1;

-- Mother DT Provider Update
SET @dataproviderId3=(SELECT id FROM dydt_data_provider WHERE `providerName`='Student Mother Info');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
    per_mother.firstName AS mother_first_name,per_mother.lastName AS mother_last_name, per_mother.mobileCountryCode as mother_mobile_country_code,per_mother.mobileNumber as mother_mobile_no
FROM students st
INNER JOIN persons per ON st.personId = per.id
INNER JOIN person_relationships per_rel ON per.id = per_rel.personId AND per_rel.relationship = "MOTHER"
INNER JOIN persons per_mother ON per_rel.relatedPersonId = per_mother.id',
    `resultColumnsDef` = 'mother_first_name,mother_last_name,mother_mobile_no,mother_mobile_country_code'
WHERE
    `dataSourceCode` = 'Student Mothers Info' AND dataProviderId = @dataproviderId3;
    
-- Parent Guardian1 DT Provider Create
SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Student Parent Guardian 1 Info', '1');

INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdataproviderId+1, 'Student Parent Guardian 1 Info', '1',null, '1', '1', 
"SELECT per_guardian1.firstName AS guardian1_first_name,per_guardian1.lastName AS guardian1_last_name, per_guardian1.mobileCountryCode as guardian1_mobile_country_code,per_guardian1.mobileNumber as guardian1_mobile_no
FROM students st
INNER JOIN persons per ON st.personId = per.id
INNER JOIN person_relationships per_rel ON per.id = per_rel.personId AND per_rel.relationship = 'GUARDIAN'
INNER JOIN persons per_guardian1 ON per_rel.relatedPersonId = per_guardian1.id", 'PRM_STUDENT_ID', 'guardian1_first_name,guardian1_last_name,guardian1_mobile_country_code,guardian1_mobile_no', "where per_rel.whetherDeleted=0 and st.userId=PRM_STUDENT_ID", '0');
   
-- Parent Guardian2 DT Provider Create   
SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Student Parent Guardian 2 Info', '1');

INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdataproviderId+1, 'Student Parent Guardian 2 Info', '1',null, '1', '1', 
"SELECT per_guardian1.firstName AS guardian2_first_name,per_guardian1.lastName AS guardian2_last_name, per_guardian1.mobileCountryCode as guardian2_mobile_country_code,per_guardian1.mobileNumber as guardian2_mobile_no
FROM students st
INNER JOIN persons per ON st.personId = per.id
INNER JOIN person_relationships per_rel ON per.id = per_rel.personId AND per_rel.relationship = 'LOCAL_GUARDIAN'
INNER JOIN persons per_guardian1 ON per_rel.relatedPersonId = per_guardian1.id", 'PRM_STUDENT_ID', 'guardian2_first_name,guardian2_last_name,guardian2_mobile_country_code,guardian2_mobile_no', "where per_rel.whetherDeleted=0 and st.userId=PRM_STUDENT_ID", '0');
   
set sql_safe_updates=1;

