
CREATE OR REPLACE VIEW `complete_day_attendance_view` AS
    SELECT 
        `adm`.`code` AS `admission_Id`,
        `usr`.`code` AS `Student_Id`,
        `pers`.`printName` AS `Student_Name`,
        `pers`.`gender` AS `Gender`,
        `acad`.`academyName` AS `Academy`,
        `loc`.`locationName` AS `Location`,
        `al`.`displayName` AS `Academy_Location`,
        `pgrp`.`groupName` AS `Program_Group`,
        `prg`.`programName` AS `Program`,
        `bch`.`batchName` AS `Batch`,
        `per`.`programPeriodName` AS `Period`,
        `at`.`itemCode` AS `Academic_Term`,
        `sec`.`sectionCode` AS `Section`,
        `spa`.`dateOfAttendance` AS `Attendance_Date`,
        `fac`.`printName` AS `Class_Teacher`,
        `amt`.`itemCode` AS `Marked_Attendance`,
        `amt`.`attendanceStatus` AS `Attendance_Status`,
        `al`.`id` AS `ACADEMY_LOCATION_ID`,
        `prg`.`id` AS `PROGRAM_ID`
    FROM
        ((((((((((((((((`student_program_attendance` `spa`
        JOIN `student_program_attendance_details` `spad` ON (((`spad`.`attendanceId` = `spa`.`id`)
            AND (`spa`.`attendanceType` = 'COMPLETE_DAY'))))
        JOIN `programs` `prg` ON ((`prg`.`id` = `spa`.`programId`)))
        JOIN `program_group` `pgrp` ON ((`pgrp`.`id` = `prg`.`programGroupId`)))
        JOIN `batches` `bch` ON ((`bch`.`id` = `spa`.`batchId`)))
        JOIN `prog_batch_period_config` `per` ON ((`per`.`id` = `spa`.`periodId`)))
        JOIN `sections` `sec` ON ((`sec`.`id` = `spa`.`periodId`)))
        LEFT JOIN `academic_term` `at` ON (((`at`.`id` = `per`.`academicTermId`)
            AND (`at`.`whetherCurrentAcademicTerm` = 1))))
        JOIN `admission` `adm` ON ((`adm`.`id` = `spad`.`admissionId`)))
        JOIN `users` `usr` ON ((`usr`.`id` = `adm`.`studentId`)))
        JOIN `academy_location` `al` ON ((`al`.`id` = `prg`.`academyLocationId`)))
        JOIN `academies` `acad` ON ((`al`.`academyId` = `acad`.`id`)))
        JOIN `locations` `loc` ON ((`loc`.`id` = `al`.`locationId`)))
        JOIN `students` `stu` ON ((`stu`.`userId` = `usr`.`id`)))
        JOIN `persons` `pers` ON ((`pers`.`id` = `stu`.`personId`)))
        JOIN `users` `fac` ON ((`fac`.`id` = `spa`.`facultyId`)))
        JOIN `attendance_marking_type` `amt` ON ((`amt`.`id` = `spad`.`attendanceMarkingTypeId`)))
    WHERE
        (`spa`.`dateOfAttendance` >= (NOW() - INTERVAL 3 MONTH))