DELIMITER $$

DROP PROCEDURE IF EXISTS add_whetherDeleted_column_to_course_coverage_plan_table $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE add_whetherDeleted_column_to_course_coverage_plan_table()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='course_coverage_plan' 
  AND COLUMN_NAME='whetherDeleted')) THEN

    ALTER TABLE `course_coverage_plan` ADD COLUMN `whetherDeleted` BIT(1) NOT NULL DEFAULT b'0' AFTER `reasonForSubstituteSession`;

  END IF;
  
   IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='course_coverage_plan' 
  AND COLUMN_NAME='reasonForSubstituteSession')) THEN
  
  ALTER TABLE `course_coverage_plan` 
	CHANGE COLUMN `reasonForSubstituteSession` `reasonForSubstituteSession` VARCHAR(500) NULL DEFAULT NULL ;

 END IF;


END $$

-- Execute the stored procedure
CALL add_whetherDeleted_column_to_course_coverage_plan_table() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS add_whetherDeleted_column_to_course_coverage_plan_table $$
 
DELIMITER ;
