DELIMITER $$

DROP PROCEDURE IF EXISTS V202001071425__InsertApplicationFollowupMSGTranslations $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001071425__InsertApplicationFollowupMSGTranslations()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'APPLICATION_HAS_BEEN_ALREADY_GRANTED' and  objectName ='ENQUIRY')) THEN
    
	-- Insert Query 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('ENQUIRY','APPLICATION_HAS_BEEN_ALREADY_GRANTED','Application has been already granted','Application has been already granted',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL V202001071425__InsertApplicationFollowupMSGTranslations() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001071425__InsertApplicationFollowupMSGTranslations $$
 
DELIMITER ;