DELIMITER $$

DROP PROCEDURE IF EXISTS batches_eligibilityCriteria $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE batches_eligibilityCriteria()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='batches' 
  AND column_name='eligibilityCriteria')) THEN
  
  -- ALTER TABLE QUERY
  ALTER TABLE `batches` 
  ADD COLUMN `eligibilityCriteria` LONGTEXT NULL DEFAULT NULL AFTER `modeOfDeliveryId`;
    
  
  END IF;

END $$

-- Execute the stored procedure
CALL batches_eligibilityCriteria $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS batches_eligibilityCriteria $$
 
DELIMITER ;