DELIMITER $$

DROP PROCEDURE IF EXISTS CreateDydtOwnerconfAcademyLocation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE CreateDydtOwnerconfAcademyLocation()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='dydt_owner_conf_academy_location' )) THEN
    
	-- CREATE STATEMENT 
	CREATE TABLE `dydt_owner_conf_academy_location` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentOwnerConfigurationId` bigint(20) DEFAULT NULL,
  `academyLocationId` varchar(45) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_dydt_owner_conf_academy_location_docOwnerConfId_idx` (`documentOwnerConfigurationId`),
  CONSTRAINT `fk_dydt_owner_conf_academy_location_docOwnerConfId` FOREIGN KEY (`documentOwnerConfigurationId`) REFERENCES `dydt_owner_conf` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

	
  END IF;

END $$

-- Execute the stored procedure
CALL CreateDydtOwnerconfAcademyLocation() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS CreateDydtOwnerconfAcademyLocation $$
 
DELIMITER ;