DELIMITER $$

DROP PROCEDURE IF EXISTS kohaUserCategoryMapping $$


CREATE PROCEDURE kohaUserCategoryMapping()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='koha_user_category_mapping')) THEN
    
	CREATE TABLE `koha_user_category_mapping` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userType` varchar(255) NOT NULL,
  `categoryId` int(10) NOT NULL,
  `userId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_koha_user_category_mapping_1_idx` (`categoryId`),
  KEY `fk_koha_user_category_mapping_2_idx` (`userId`),
  KEY `fk_koha_user_category_mapping_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_koha_user_category_mapping_1` FOREIGN KEY (`categoryId`) REFERENCES `koha_categories` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_koha_user_category_mapping_2` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_koha_user_category_mapping_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	
  END IF;


  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='koha_user_library_mapping')) THEN
  
CREATE TABLE `koha_user_library_mapping` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userType` varchar(255) NOT NULL,
  `branchId` bigint(10) NOT NULL,
  `userId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_koha_user_library_mapping_1_idx` (`branchId`),
  KEY `fk_koha_user_library_mapping_2_idx` (`userId`),
  KEY `fk_koha_user_library_mapping_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_koha_user_library_mapping_mapping_1` FOREIGN KEY (`branchId`) REFERENCES `koha_branches` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_koha_user_library_mapping_mapping_2` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_koha_user_library_mapping_mapping_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF;


END $$

-- Execute the stored procedure
CALL kohaUserCategoryMapping $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS kohaUserCategoryMapping $$
 
DELIMITER ;