DELIMITER $$

DROP PROCEDURE IF EXISTS InsertPendingAttendanceTrnsKey $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE InsertPendingAttendanceTrnsKey()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'PROGRAMANDCOURSE'  and keyName = 'ATTENDANCE_PENDING_REPORT')) THEN
    
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PROGRAMANDCOURSE','ATTENDANCE_PENDING_REPORT','Attendance Pending','Attendance Pending',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL InsertPendingAttendanceTrnsKey() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS InsertPendingAttendanceTrnsKey $$
 
DELIMITER ;