DELIMITER $$

DROP PROCEDURE IF EXISTS V202001232006__UpdateCustomTableConfig $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001232006__UpdateCustomTableConfig()

BEGIN
 
 IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='custom_table_configs' AND column_name='viewCode')) THEN

 SET SQL_SAFE_UPDATES = 0;
 
  UPDATE `custom_table_configs` SET displayName='Student Personal Details', viewCode='STUDENT_LIST' where displayName='Person' AND customTableName='person_cd';

  UPDATE `custom_table_configs` SET viewCode='PARENT_AND_GUARDIAN' where displayName='Parent And Guardians' AND customTableName='person_cd';
 
  SET SQL_SAFE_UPDATES = 1;
 END IF;

 
IF NOT EXISTS ((SELECT * FROM custom_table_configs where displayName='Employee Personal Details' AND tableName='persons')) THEN 
INSERT INTO `custom_table_configs` (`displayName`, `tableName`, `customTableName`, `viewCode`) VALUES ('Employee Personal Details', 'persons', 'person_cd', 'FACULTY_LIST');
END IF; 
 
END $$

-- Execute the stored procedure
CALL V202001232006__UpdateCustomTableConfig() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001232006__UpdateCustomTableConfig $$
 
DELIMITER ;


