DELIMITER $$

DROP PROCEDURE IF EXISTS InsertStudentHostelLeaveTranslation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE InsertStudentHostelLeaveTranslation()

BEGIN
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='STU_HOSTEL_LEAVE_APPROVE')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','STU_HOSTEL_LEAVE_APPROVE','Student Hostel Leave Approve','Student Hostel Leave Approve',now(),1);

  END IF; 
  
   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_HOSTEL_LEAVE_APPROVE')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','STUDENT_HOSTEL_LEAVE_APPROVE','Student Hostel Leave Approve','Student Hostel Leave Approve',now(),1);

  END IF; 
  
   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_HOSTEL_LEAVE_APPROVE_DL')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','STUDENT_HOSTEL_LEAVE_APPROVE_DL','Student Hostel Leave Approve DL','Student Hostel Leave Approve DL',now(),1);

  END IF; 
  
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_HOSTEL_LEAVE_APPROVE_RCPNT')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','STUDENT_HOSTEL_LEAVE_APPROVE_RCPNT','Student Hostel Leave Approve Recipient','Student Hostel Leave Approve Recipient',now(),1);

  END IF;
  
  
   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='RESPONSIBLE_PER_FIRST_NAME')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','RESPONSIBLE_PER_FIRST_NAME','Responsible Person First Name','Responsible Person First Name',now(),1);

  END IF;
  
   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='RESPONSIBLE_PER_MIDDLE_NAME')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','RESPONSIBLE_PER_MIDDLE_NAME','Responsible Person Middle Name','Responsible Person Middle Name',now(),1);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='RESPONSIBLE_PER_LAST_NAME')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','RESPONSIBLE_PER_LAST_NAME','Responsible Person Last Name','Responsible Person Last Name',now(),1);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_NAME')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','HOSTEL_NAME','Hostel Name','Hostel Name',now(),1);

  END IF;
  
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='REQUEST_ID')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','REQUEST_ID','Request ID','Request ID',now(),1);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='STUDENT_HOSTEL_LEAVE_APPROVE_DL')) THEN

  INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('STUDENT_HOSTEL_LEAVE_APPROVE_DL', 'Student Hostel Leave Approve DL');

  END IF;
  
   IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='STUDENT_HOSTEL_LEAVE_APPROVE_RCPNT')) THEN

  INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('STUDENT_HOSTEL_LEAVE_APPROVE_RCPNT', 'Student Hostel Leave Approve Recipient');

  END IF;

END $$

-- Execute the stored procedure
CALL InsertStudentHostelLeaveTranslation() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS InsertStudentHostelLeaveTranslation $$
 
DELIMITER ;