DELIMITER $$

DROP PROCEDURE IF EXISTS insert_record_ui_translation_table_to_world_database $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE insert_record_ui_translation_table_to_world_database()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='NOT_CONFIGURED_COMBINATIONS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','NOT_CONFIGURED_COMBINATIONS','Not Configured Combinations','Not Configured Combinations',now(),1);
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='ADMISSION_CYCLE_STATUS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','ADMISSION_CYCLE_STATUS','Admission Cycle Status', 'Admission Cycle Status',now(),1);

  END IF;
  
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='PROGRAM_BATCH_COMBINATION_GRID')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','PROGRAM_BATCH_COMBINATION_GRID','List of Program Batch Combinations','List of Program Batch Combinations',now(),1);

  END IF;  
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='FORM_SALE_STATUS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','FORM_SALE_STATUS','Form Sale Status', 'Form Sale Status',now(),1);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='CONFIGURE_COMBINATION')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','CONFIGURE_COMBINATION','Configure', 'Configure',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL insert_record_ui_translation_table_to_world_database() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS insert_record_ui_translation_table_to_world_database $$
 
DELIMITER ;