DELIMITER $$
DROP PROCEDURE IF EXISTS V20200518160608__Create_DocumentStatusTable $$
CREATE PROCEDURE V20200518160608__Create_DocumentStatusTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='document_status')) THEN 
CREATE TABLE `document_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(100) NOT NULL,
  `itemValue` varchar(100) NOT NULL,
  `isDeletable` BIT(1) NOT NULL DEFAULT 1,
 `isEditable` BIT(1) NOT NULL DEFAULT 1,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   `lastUpdatedBy` BIGINT(20),
   PRIMARY KEY (`id`),
  KEY `fk_document_status_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_document_status_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20200518160608__Create_DocumentStatusTable () $$ 
DROP PROCEDURE IF EXISTS V20200518160608__Create_DocumentStatusTable $$ 
DELIMITER ;